/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.model;

import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Dimension2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

public class Bucket {
    private Point2D position = new Point2D.Double();
    protected final Shape holeShape;
    private final Shape containerShape;
    private final Color baseColor;
    private final String captionText;

    public Bucket(double d, double d2, Dimension2D dimension2D, Color color, String string) {
        this(new Point2D.Double(d, d2), dimension2D, color, string);
    }

    public Bucket(Point2D point2D, Dimension2D dimension2D, Color color, String string) {
        this.position.setLocation(point2D);
        this.baseColor = color;
        this.captionText = string;
        this.holeShape = new Ellipse2D.Double(-dimension2D.getWidth() / 2.0, -dimension2D.getHeight() * 0.25 / 2.0, dimension2D.getWidth(), dimension2D.getHeight() * 0.25);
        double d = dimension2D.getHeight() * 0.875;
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        doubleGeneralPath.moveTo(-dimension2D.getWidth() * 0.5, 0.0);
        doubleGeneralPath.lineTo(-dimension2D.getWidth() * 0.4, -d * 0.8);
        doubleGeneralPath.curveTo(-dimension2D.getWidth() * 0.3, -d * 0.8 - dimension2D.getHeight() * 0.25 * 0.6, dimension2D.getWidth() * 0.3, -d * 0.8 - dimension2D.getHeight() * 0.25 * 0.6, dimension2D.getWidth() * 0.4, -d * 0.8);
        doubleGeneralPath.lineTo(dimension2D.getWidth() * 0.5, 0.0);
        doubleGeneralPath.closePath();
        Area area = new Area(doubleGeneralPath.getGeneralPath());
        area.subtract(new Area(this.holeShape));
        this.containerShape = area;
    }

    public Point2D getPosition() {
        return this.position;
    }

    public Shape getHoleShape() {
        return this.holeShape;
    }

    public Shape getContainerShape() {
        return this.containerShape;
    }

    public Color getBaseColor() {
        return this.baseColor;
    }

    public String getCaptionText() {
        return this.captionText;
    }
}

