/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.event;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.geom.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelativeDragHandler
extends PBasicInputEventHandler {
    private final ModelViewTransform transform;
    private final Property<ImmutableVector2D> modelLocation;
    private final Function1<Point2D, Point2D> constraint;
    private final PNode node;
    private Point2D.Double relativeGrabPoint;

    public RelativeDragHandler(PNode pNode, ModelViewTransform modelViewTransform, Property<ImmutableVector2D> property, Function1<Point2D, Point2D> function1) {
        this.node = pNode;
        this.transform = modelViewTransform;
        this.modelLocation = property;
        this.constraint = function1;
    }

    @Override
    public void mousePressed(PInputEvent pInputEvent) {
        this.updateGrabPoint(pInputEvent);
    }

    private void updateGrabPoint(PInputEvent pInputEvent) {
        Point2D point2D = pInputEvent.getPositionRelativeTo(this.node.getParent());
        ImmutableVector2D immutableVector2D = this.transform.modelToView(this.modelLocation.get());
        this.relativeGrabPoint = new Point2D.Double(point2D.getX() - immutableVector2D.getX(), point2D.getY() - immutableVector2D.getY());
    }

    @Override
    public void mouseDragged(PInputEvent pInputEvent) {
        if (this.relativeGrabPoint == null) {
            this.updateGrabPoint(pInputEvent);
        }
        Point2D point2D = pInputEvent.getPositionRelativeTo(this.node.getParent());
        Point2D point2D2 = this.transform.viewToModel(point2D.getX() - this.relativeGrabPoint.getX(), point2D.getY() - this.relativeGrabPoint.getY());
        Point2D point2D3 = this.constraint.apply(point2D2);
        this.setModelPosition(point2D3);
    }

    protected void setModelPosition(Point2D point2D) {
        this.modelLocation.set(new ImmutableVector2D(point2D));
    }

    @Override
    public void mouseReleased(PInputEvent pInputEvent) {
        this.relativeGrabPoint = null;
    }
}

