/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.phetcommon.model.Bucket;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class BucketView {
    public static final Font DEFAULT_LABEL_FONT = new PhetFont(18, true);
    private final PNode holeLayer = new PNode();
    private final PNode containerLayer = new PNode();

    public BucketView(Bucket bucket, ModelViewTransform modelViewTransform, Color color, Font font) {
        AffineTransform affineTransform = AffineTransform.getScaleInstance(modelViewTransform.getTransform().getScaleX(), modelViewTransform.getTransform().getScaleY());
        Shape shape = affineTransform.createTransformedShape(bucket.getHoleShape());
        Shape shape2 = affineTransform.createTransformedShape(bucket.getContainerShape());
        GradientPaint gradientPaint = new GradientPaint(new Point2D.Double(shape.getBounds2D().getMinX(), shape.getBounds2D().getCenterY()), ColorUtils.brighterColor(bucket.getBaseColor(), 0.5), new Point2D.Double(shape.getBounds2D().getMaxX(), shape.getBounds2D().getCenterY()), ColorUtils.darkerColor(bucket.getBaseColor(), 0.5));
        PhetPPath phetPPath = new PhetPPath(shape2, (Paint)gradientPaint);
        this.containerLayer.addChild(phetPPath);
        GradientPaint gradientPaint2 = new GradientPaint(new Point2D.Double(shape.getBounds2D().getMinX(), shape.getBounds2D().getCenterY()), Color.BLACK, new Point2D.Double(shape.getBounds2D().getMaxX(), shape.getBounds2D().getCenterY()), Color.LIGHT_GRAY);
        PhetPPath phetPPath2 = new PhetPPath(shape, gradientPaint2, new BasicStroke(1.0f), Color.GRAY);
        this.holeLayer.addChild(phetPPath2);
        if (bucket.getCaptionText() != null) {
            PText pText = new PText(bucket.getCaptionText());
            pText.setFont(font);
            pText.setTextPaint(color);
            if (pText.getFullBoundsReference().getWidth() > shape2.getBounds().getWidth() * 0.8) {
                pText.scale(shape2.getBounds().getWidth() * 0.8 / pText.getFullBoundsReference().getWidth());
            }
            pText.setOffset(shape2.getBounds2D().getCenterX() - pText.getFullBoundsReference().getWidth() / 2.0, shape2.getBounds2D().getCenterY() - pText.getFullBoundsReference().getHeight() / 2.0);
            this.containerLayer.addChild(pText);
        }
        this.setOffset(modelViewTransform.modelToView(bucket.getPosition()));
    }

    public PNode getHoleNode() {
        return this.holeLayer;
    }

    public PNode getFrontNode() {
        return this.containerLayer;
    }

    private void setOffset(double d, double d2) {
        this.holeLayer.setOffset(d, d2);
        this.containerLayer.setOffset(d, d2);
    }

    private void setOffset(Point2D point2D) {
        this.setOffset(point2D.getX(), point2D.getY());
    }
}

