/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.phetcommon.view.graphics.TriColorRoundGradientPaint;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.SphericalNode;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Point2D;

public class ShadedSphereNode
extends PhetPNode {
    private static final Color DEFAULT_HIGHLIGHT = Color.WHITE;
    private static final Color DEFAULT_SHADOW = Color.BLACK;
    private final SphericalNode sphericalNode;
    private final Color highlightColor;
    private final Color mainColor;
    private final Color shadowColor;

    public ShadedSphereNode(double d, Color color, Color color2, Color color3) {
        this(d, color, color2, color3, false);
    }

    public ShadedSphereNode(double d, Color color, Color color2, Color color3, boolean bl) {
        this.mainColor = color;
        this.highlightColor = color2;
        this.shadowColor = color3;
        this.sphericalNode = new SphericalNode(d, this.createPaint(d, color2, color, color3), bl);
        this.addChild(this.sphericalNode);
    }

    protected Point2D getHighlightCenter(double d) {
        return new Point2D.Double(-d / 6.0, -d / 6.0);
    }

    private Paint createPaint(double d, Color color, Color color2, Color color3) {
        Point2D point2D = this.getHighlightCenter(d);
        double d2 = d / 3.0;
        double d3 = 0.7 * d;
        return new TriColorRoundGradientPaint(color, color2, color3, point2D.getX(), point2D.getY(), d2, d3);
    }
}

