/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.common.model;

import edu.colorado.phet.common.phetcommon.model.ResetModel;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.property.And;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import java.util.ArrayList;

public abstract class AbstractSugarAndSaltSolutionsModel
implements ResetModel {
    private final ArrayList<VoidFunction0> resetListeners = new ArrayList();
    public final ConstantDtClock clock;
    public final BooleanProperty clockRunning = new BooleanProperty(true);
    public final BooleanProperty moduleActive = new BooleanProperty(false);

    public AbstractSugarAndSaltSolutionsModel(final ConstantDtClock constantDtClock) {
        this.clock = constantDtClock;
        constantDtClock.addClockListener(new ClockAdapter(){

            public void simulationTimeChanged(ClockEvent clockEvent) {
                AbstractSugarAndSaltSolutionsModel.this.updateModel(clockEvent.getSimulationTimeChange());
            }
        });
        And and = this.clockRunning.and(this.moduleActive);
        and.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                if (bl.booleanValue()) {
                    constantDtClock.start();
                } else {
                    constantDtClock.pause();
                }
            }
        });
    }

    protected abstract double updateModel(double var1);

    public void addResetListener(VoidFunction0 voidFunction0) {
        this.resetListeners.add(voidFunction0);
    }

    protected void notifyReset() {
        for (VoidFunction0 voidFunction0 : this.resetListeners) {
            voidFunction0.apply();
        }
    }
}

