/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.common.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.sugarandsaltsolutions.common.model.SphericalParticle;
import java.util.ArrayList;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectedPositions {
    private final String text;
    private final double scale;

    public ProjectedPositions(String string, double d) {
        this.text = string;
        this.scale = d;
    }

    public ArrayList<AtomPosition> getAtoms() {
        ArrayList<AtomPosition> arrayList = new ArrayList<AtomPosition>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.text, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(this.parseAtom(stringTokenizer.nextToken()));
        }
        return arrayList;
    }

    private AtomPosition parseAtom(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        String string2 = stringTokenizer.nextToken();
        double d = Double.parseDouble(stringTokenizer.nextToken());
        double d2 = Double.parseDouble(stringTokenizer.nextToken());
        String string3 = "";
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        final String string4 = string3;
        return new AtomPosition(string2, this.toModel(new ImmutableVector2D(d, d2))){

            public SphericalParticle createConstituent() {
                if (this.type.equals("H")) {
                    return new SphericalParticle.Hydrogen(){

                        public double getPartialChargeDisplayValue() {
                            if (string4.equals("charge")) {
                                return super.getPartialChargeDisplayValue();
                            }
                            return 0.0;
                        }
                    };
                }
                if (this.type.equals("C")) {
                    return new SphericalParticle.Carbon(){

                        public double getPartialChargeDisplayValue() {
                            if (string4.equals("charge")) {
                                return 1.0;
                            }
                            return 0.0;
                        }
                    };
                }
                if (this.type.equals("O")) {
                    return new SphericalParticle.NeutralOxygen(){

                        public double getPartialChargeDisplayValue() {
                            if (string4.equals("charge")) {
                                return super.getPartialChargeDisplayValue();
                            }
                            return 0.0;
                        }
                    };
                }
                throw new RuntimeException();
            }
        };
    }

    public ImmutableVector2D getOrigin() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.text.substring(0, this.text.indexOf(10)), ", ");
        stringTokenizer.nextToken();
        return new ImmutableVector2D(Double.parseDouble(stringTokenizer.nextToken()), Double.parseDouble(stringTokenizer.nextToken()));
    }

    private ImmutableVector2D toModel(ImmutableVector2D immutableVector2D) {
        return immutableVector2D.minus(this.getOrigin()).times(this.scale);
    }

    public static abstract class AtomPosition {
        public final String type;
        public final ImmutableVector2D position;

        AtomPosition(String string, ImmutableVector2D immutableVector2D) {
            this.type = string;
            this.position = immutableVector2D;
        }

        public abstract SphericalParticle createConstituent();
    }
}

