/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.common.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Beaker;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Dispenser;
import edu.colorado.phet.sugarandsaltsolutions.common.model.DispenserType;
import edu.colorado.phet.sugarandsaltsolutions.common.model.SugarAndSaltSolutionModel;
import edu.colorado.phet.sugarandsaltsolutions.common.view.SaltShakerNode;
import edu.umd.cs.piccolo.PNode;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SaltShaker<T extends SugarAndSaltSolutionModel>
extends Dispenser<T> {
    private final Random random = new Random();
    private double shakeAmount;
    private final ArrayList<ImmutableVector2D> positions = new ArrayList();

    public SaltShaker(double d, double d2, Beaker beaker, ObservableProperty<Boolean> observableProperty, String string, double d3, ObservableProperty<DispenserType> observableProperty2, DispenserType dispenserType, T t) {
        super(d, d2, 2.356194490192345, beaker, observableProperty, string, d3, observableProperty2, dispenserType, t);
        observableProperty.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                if (!bl.booleanValue()) {
                    SaltShaker.this.shakeAmount = 0.0;
                    SaltShaker.this.positions.clear();
                }
            }
        });
    }

    @Override
    public void translate(Dimension2D dimension2D) {
        super.translate(dimension2D);
        if (((Boolean)this.moreAllowed.get()).booleanValue()) {
            this.positions.add((ImmutableVector2D)this.center.get());
            while (this.positions.size() > 50) {
                this.positions.remove(0);
            }
            if (this.positions.size() >= 20) {
                ImmutableVector2D immutableVector2D = new ImmutableVector2D();
                int n = 10;
                for (int i = 0; i < n; ++i) {
                    immutableVector2D = immutableVector2D.plus(this.getSecondDerivative(i));
                }
                immutableVector2D = immutableVector2D.times(1.0 / (double)n);
                double d = Math.abs(immutableVector2D.dot(ImmutableVector2D.createPolar(1.0, (Double)this.angle.get() + 1.5707963267948966)));
                if ((d *= this.distanceScale) > 1.0E-4) {
                    this.shakeAmount += d;
                }
            }
        }
    }

    @Override
    public void updateModel() {
        if (((Boolean)this.enabled.get()).booleanValue() && this.shakeAmount > 0.0 && ((Boolean)this.moreAllowed.get()).booleanValue()) {
            int n = (int)((double)this.random.nextInt(2) + Math.min(this.shakeAmount * 4000.0, 4.0));
            for (int i = 0; i < n; ++i) {
                double d = (this.random.nextDouble() - 0.5) * 2.0;
                ImmutableVector2D immutableVector2D = ((ImmutableVector2D)this.center.get()).plus(ImmutableVector2D.createPolar(this.dispenserHeight / 2.0 * 0.8, (Double)this.angle.get() - 1.5707963267948966 + d * Math.PI / 32.0 * 1.2));
                this.addSalt(this.model, immutableVector2D, 2.699E-5, this.getCrystalVelocity(immutableVector2D));
                this.shakeAmount = 0.0;
            }
        }
    }

    protected abstract void addSalt(T var1, ImmutableVector2D var2, double var3, ImmutableVector2D var5);

    @Override
    public PNode createNode(ModelViewTransform modelViewTransform, boolean bl, Function1<Point2D, Point2D> function1) {
        return new SaltShakerNode(modelViewTransform, this, bl, function1);
    }

    @Override
    public void reset() {
        super.reset();
        this.shakeAmount = 0.0;
        this.positions.clear();
    }

    private ImmutableVector2D getSecondDerivative(int n) {
        ImmutableVector2D immutableVector2D = this.positions.get(this.positions.size() - 1 - n);
        ImmutableVector2D immutableVector2D2 = this.positions.get(this.positions.size() - 2 - n);
        ImmutableVector2D immutableVector2D3 = this.positions.get(this.positions.size() - 3 - n);
        return immutableVector2D.minus(immutableVector2D2.times(2.0)).plus(immutableVector2D3);
    }
}

