/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.common.view;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.event.RelativeDragHandler;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Dispenser;
import edu.colorado.phet.sugarandsaltsolutions.common.model.SugarAndSaltSolutionModel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispenserNode<U extends SugarAndSaltSolutionModel, T extends Dispenser<U>>
extends PNode {
    private final boolean debug = false;
    protected final PImage imageNode;
    private final ModelViewTransform transform;
    private final T model;
    private final PNode textLabel;

    public DispenserNode(ModelViewTransform modelViewTransform, T t, Function1<Point2D, Point2D> function1) {
        this.transform = modelViewTransform;
        this.model = t;
        this.imageNode = new PImage();
        this.addChild(this.imageNode);
        this.textLabel = new PNode((Dispenser)t){
            final /* synthetic */ Dispenser val$model;
            {
                this.val$model = dispenser;
                this.addChild(new HTMLNode(this.val$model.name){
                    {
                        this.setFont(new PhetFont(30));
                        this.rotateInPlace(1.5707963267948966);
                    }
                });
            }
        };
        this.imageNode.addChild(this.textLabel);
        new RichSimpleObserver(){

            public void update() {
                DispenserNode.this.updateTransform();
            }
        }.observe(((Dispenser)t).center, ((Dispenser)t).angle);
        this.addInputEventListener(new RelativeDragHandler(this, modelViewTransform, ((Dispenser)t).center, function1, (Dispenser)t, modelViewTransform){
            final /* synthetic */ Dispenser val$model;
            final /* synthetic */ ModelViewTransform val$transform;
            {
                this.val$model = dispenser;
                this.val$transform = modelViewTransform2;
                super(pNode, modelViewTransform, property, function1);
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                this.val$model.setDispenserHeight(this.val$transform.viewToModelDeltaY(DispenserNode.this.imageNode.getFullBounds().getHeight()));
                super.mouseDragged(pInputEvent);
                DispenserNode.this.moveToFront();
            }

            protected void setModelPosition(Point2D point2D) {
                ImmutableVector2D immutableVector2D = this.val$model.center.get();
                ImmutableVector2D immutableVector2D2 = new ImmutableVector2D(point2D);
                ImmutableVector2D immutableVector2D3 = immutableVector2D2.minus(immutableVector2D);
                this.val$model.translate(immutableVector2D3.toDimension());
            }
        });
        this.addInputEventListener(new CursorHandler());
    }

    protected void updateTransform() {
        this.imageNode.setTransform(new AffineTransform());
        Point2D.Double double_ = this.transform.modelToView(((Dispenser)this.model).center.get()).toPoint2D();
        this.imageNode.rotate(-((Double)((Dispenser)this.model).angle.get()).doubleValue());
        this.imageNode.centerFullBoundsOnPoint(double_.x, double_.y);
        this.textLabel.setOffset(this.imageNode.getWidth() / 2.0 - this.textLabel.getFullBounds().getWidth() / 2.0, this.imageNode.getHeight() / 2.0 - this.textLabel.getFullBounds().getWidth() / 2.0);
    }
}

