/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.common.view;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.controls.PropertyRadioButton;
import edu.colorado.phet.sugarandsaltsolutions.common.model.DispenserType;
import edu.colorado.phet.sugarandsaltsolutions.common.view.BeakerAndShakerCanvas;
import edu.colorado.phet.sugarandsaltsolutions.common.view.SelectableSoluteItem;
import edu.umd.cs.piccolox.pswing.PSwing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispenserRadioButtonSet
extends PSwing {
    private final Property<DispenserType> dispenserType;
    private final SelectableSoluteItem[] items;

    public DispenserRadioButtonSet(final Property<DispenserType> property, final SelectableSoluteItem ... selectableSoluteItemArray) {
        super(new VerticalLayoutPanel(){
            {
                for (SelectableSoluteItem selectableSoluteItem : selectableSoluteItemArray) {
                    this.add(new PropertyRadioButton<DispenserType>(selectableSoluteItem.name, (SettableProperty)property, selectableSoluteItem.dispenserType){
                        {
                            this.setFont(BeakerAndShakerCanvas.CONTROL_FONT);
                        }
                    });
                }
            }
        });
        this.dispenserType = property;
        this.items = selectableSoluteItemArray;
    }

    public void setSelected() {
        if (!this.containsDispenser()) {
            this.dispenserType.set(this.items[0].dispenserType);
        }
    }

    private boolean containsDispenser() {
        boolean bl = false;
        for (SelectableSoluteItem selectableSoluteItem : this.items) {
            if (selectableSoluteItem.dispenserType != this.dispenserType.get()) continue;
            bl = true;
        }
        return bl;
    }
}

