/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.common.view;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.nodes.faucet.FaucetNode;
import edu.colorado.phet.sugarandsaltsolutions.common.model.SugarAndSaltSolutionModel;
import edu.umd.cs.piccolo.PNode;
import java.awt.geom.Rectangle2D;

public class FaucetMetrics {
    private final ImmutableVector2D inputPoint;
    public final ImmutableVector2D outputPoint;
    private final SugarAndSaltSolutionModel model;
    public final double faucetWidth;

    public FaucetMetrics(ModelViewTransform modelViewTransform, SugarAndSaltSolutionModel sugarAndSaltSolutionModel, PNode pNode, FaucetNode faucetNode) {
        this(sugarAndSaltSolutionModel, modelViewTransform.viewToModel(new ImmutableVector2D(pNode.globalToLocal(faucetNode.getInputGlobalViewPoint()))), modelViewTransform.viewToModel(new ImmutableVector2D(pNode.globalToLocal(faucetNode.getOutputGlobalViewPoint()))), modelViewTransform.viewToModelDeltaX(pNode.globalToLocal(faucetNode.getGlobalFaucetWidthDimension()).getWidth()));
    }

    public FaucetMetrics(SugarAndSaltSolutionModel sugarAndSaltSolutionModel, ImmutableVector2D immutableVector2D, ImmutableVector2D immutableVector2D2, double d) {
        this.inputPoint = immutableVector2D;
        this.outputPoint = immutableVector2D2;
        this.model = sugarAndSaltSolutionModel;
        this.faucetWidth = d;
    }

    public ImmutableVector2D getInputPoint() {
        Rectangle2D rectangle2D = this.model.solution.shape.get().getBounds2D();
        if (rectangle2D.getBounds2D().getMinY() < this.inputPoint.toPoint2D().getY() && this.inputPoint.toPoint2D().getY() < rectangle2D.getBounds2D().getMaxY()) {
            return this.inputPoint;
        }
        return new ImmutableVector2D(this.inputPoint.getX(), rectangle2D.getMaxY());
    }

    public FaucetMetrics clampInputWithinFluid(double d) {
        return new FaucetMetrics(this.model, new ImmutableVector2D(d, this.inputPoint.getY()), this.outputPoint, this.faucetWidth);
    }
}

