/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.macro.model;

import edu.colorado.phet.common.phetcommon.model.property.doubleproperty.CompositeDoubleProperty;
import edu.colorado.phet.common.phetcommon.model.property.doubleproperty.DoubleProperty;
import edu.colorado.phet.common.phetcommon.model.property.doubleproperty.Max;
import edu.colorado.phet.common.phetcommon.model.property.doubleproperty.Min;

public class SoluteModel {
    public final DoubleProperty moles;
    public final CompositeDoubleProperty molesPrecipitated;
    public final CompositeDoubleProperty molesDissolved;
    public final CompositeDoubleProperty saturationPointMoles;
    public final CompositeDoubleProperty solidVolume;
    public final CompositeDoubleProperty grams;
    public final double gramsPerMole;
    public final double volumePerSolidMole;

    public SoluteModel(DoubleProperty doubleProperty, double d, double d2, double d3) {
        this.volumePerSolidMole = d2;
        this.gramsPerMole = d3;
        this.moles = new DoubleProperty(0.0);
        this.saturationPointMoles = doubleProperty.times(d);
        this.molesDissolved = new Min(this.moles, this.saturationPointMoles);
        this.molesPrecipitated = new Max(this.moles.minus(this.molesDissolved), 0.0);
        this.solidVolume = this.molesPrecipitated.times(d2);
        this.grams = this.moles.times(d3);
    }
}

