/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.macro.view;

import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.PhetColorScheme;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.conductivitytester.ConductivityTesterNode;
import edu.colorado.phet.common.piccolophet.nodes.conductivitytester.IConductivityTester;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.CanvasBoundedDragHandler;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.DragEvent;
import edu.colorado.phet.sugarandsaltsolutions.common.model.ConductivityTester;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.Image;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SugarAndSaltSolutionsConductivityTesterNode
extends ConductivityTesterNode {
    private final ConductivityTester conductivityTester;
    private final ModelViewTransform transform;

    public SugarAndSaltSolutionsConductivityTesterNode(final ConductivityTester conductivityTester, final ModelViewTransform modelViewTransform, final PNode pNode, Point2D point2D, ObservableProperty<Boolean> observableProperty) {
        super(conductivityTester, modelViewTransform, Color.lightGray, Color.lightGray, Color.lightGray, PhetColorScheme.RED_COLORBLIND, Color.green, Color.black, Color.black, false);
        this.conductivityTester = conductivityTester;
        this.transform = modelViewTransform;
        observableProperty.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                if (bl.booleanValue()) {
                    SugarAndSaltSolutionsConductivityTesterNode.this.setAgainstWhiteBackground();
                } else {
                    SugarAndSaltSolutionsConductivityTesterNode.this.setAgainstDarkBackground();
                }
            }
        });
        conductivityTester.visible.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                SugarAndSaltSolutionsConductivityTesterNode.this.setVisible(bl);
            }
        });
        this.getLightBulbNode().addInputEventListener(new CursorHandler());
        this.getLightBulbNode().addInputEventListener(new CanvasBoundedDragHandler(this.getLightBulbNode()){

            protected void dragNode(DragEvent dragEvent) {
                SugarAndSaltSolutionsConductivityTesterNode.this.dragAll(dragEvent.delta);
            }
        });
        this.getBatteryNode().addInputEventListener(new CursorHandler());
        this.getBatteryNode().addInputEventListener(new CanvasBoundedDragHandler(this.getBatteryNode()){

            protected void dragNode(DragEvent dragEvent) {
                SugarAndSaltSolutionsConductivityTesterNode.this.dragAll(dragEvent.delta);
            }
        });
        Point2D point2D2 = modelViewTransform.modelToView(point2D);
        conductivityTester.setLocation(point2D2.getX(), point2D2.getY());
        double d = 0.065;
        conductivityTester.setNegativeProbeLocation(point2D.getX() - 0.03, point2D.getY() - d);
        conductivityTester.setPositiveProbeLocation(point2D.getX() + 0.07, point2D.getY() - d);
        conductivityTester.addConductivityTesterChangeListener(new IConductivityTester.ConductivityTesterChangeListener(){

            public void brightnessChanged() {
            }

            public void positiveProbeLocationChanged() {
            }

            public void negativeProbeLocationChanged() {
            }

            public void locationChanged() {
                Rectangle2D rectangle2D = SugarAndSaltSolutionsConductivityTesterNode.this.getBatteryNode().getGlobalFullBounds();
                rectangle2D = pNode.globalToLocal(rectangle2D);
                conductivityTester.setBatteryRegion(modelViewTransform.viewToModel(rectangle2D));
                Rectangle2D rectangle2D2 = SugarAndSaltSolutionsConductivityTesterNode.this.getLightBulbNode().getGlobalFullBounds();
                rectangle2D2 = pNode.globalToLocal(rectangle2D2);
                conductivityTester.setBulbRegion(modelViewTransform.viewToModel(rectangle2D2));
            }
        });
    }

    public Image createImage() {
        boolean bl = this.conductivityTester.visible.get();
        this.conductivityTester.visible.set(true);
        Image image = this.toImage();
        this.conductivityTester.visible.set(bl);
        return image;
    }

    public void dragAll(PDimension pDimension) {
        this.conductivityTester.setLocation(this.conductivityTester.getLocationReference().getX() + pDimension.getWidth(), this.conductivityTester.getLocationReference().getY() + pDimension.getHeight());
        Dimension2D dimension2D = this.transform.viewToModelDelta(pDimension);
        this.conductivityTester.setNegativeProbeLocation(this.conductivityTester.getNegativeProbeLocationReference().getX() + dimension2D.getWidth(), this.conductivityTester.getNegativeProbeLocationReference().getY() + dimension2D.getHeight());
        this.conductivityTester.setPositiveProbeLocation(this.conductivityTester.getPositiveProbeLocationReference().getX() + dimension2D.getWidth(), this.conductivityTester.getPositiveProbeLocationReference().getY() + dimension2D.getHeight());
        this.getParent().moveToFront();
    }

    public PNode[] getDroppableComponents() {
        return new PNode[]{this.getLightBulbNode(), this.getBatteryNode()};
    }
}

