/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Constituent;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Crystal;
import edu.colorado.phet.sugarandsaltsolutions.common.model.ItemList;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Particle;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.MicroModel;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.FreeParticleStrategy;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrystalDissolve<T extends Particle> {
    private long lastDissolve = System.currentTimeMillis();
    private final MicroModel model;

    public CrystalDissolve(MicroModel microModel) {
        this.model = microModel;
    }

    public void dissolve(ItemList<Crystal<T>> itemList, Crystal<T> crystal, ObservableProperty<Boolean> observableProperty) {
        while (!observableProperty.get().booleanValue() && crystal.numberConstituents() > 0 && System.currentTimeMillis() - this.lastDissolve > 2L && !this.model.isWaterBelowCrystalThreshold()) {
            this.lastDissolve = System.currentTimeMillis();
            Option<ArrayList<Constituent<T>>> option = crystal.getConstituentsToDissolve(this.model.solution.shape.get().getBounds2D());
            if (!option.isSome()) continue;
            this.dissolve(crystal, option.get());
        }
        if (crystal.numberConstituents() == 1) {
            this.removeConstituent(crystal, crystal.getConstituent(0));
        }
        if (crystal.numberConstituents() == 0) {
            itemList.remove(crystal);
        }
    }

    public void dissolve(Crystal<T> crystal, ArrayList<Constituent<T>> arrayList) {
        for (Constituent<T> constituent : arrayList) {
            this.removeConstituent(crystal, constituent);
        }
    }

    private void removeConstituent(Crystal<T> crystal, Constituent<T> constituent) {
        boolean bl = ((Particle)constituent.particle).getShape().getBounds2D().getMaxY() > this.model.solution.shape.get().getBounds2D().getMaxY();
        double d = bl ? 0.0 : Math.random() * Math.PI * 2.0;
        ImmutableVector2D immutableVector2D = new ImmutableVector2D(0.0, -1.0).times(6.0E-10).getRotatedInstance(d);
        ((Particle)constituent.particle).velocity.set(immutableVector2D);
        crystal.removeConstituent(constituent);
        this.model.freeParticles.add((Particle)constituent.particle);
        ((Particle)constituent.particle).setUpdateStrategy(new FreeParticleStrategy(this.model));
    }
}

