/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.logging.LoggingUtils;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Formula;
import edu.colorado.phet.sugarandsaltsolutions.common.model.ItemList;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Particle;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.MicroModel;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.DrainData;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.FlowOutOfDrainStrategy;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.FlowToDrainStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Draining {
    private final MicroModel model;
    private final ArrayList<Particle> usedParticles = new ArrayList();
    private static final Logger LOGGER = LoggingUtils.getLogger(Draining.class.getCanonicalName());

    public Draining(MicroModel microModel) {
        this.model = microModel;
    }

    public void clearParticleGroupings() {
        this.usedParticles.clear();
    }

    public double getTimeToError(DrainData drainData, double d) {
        double d2 = (Double)this.model.outputFlowRate.get() * this.model.faucetFlowRate;
        int n = this.model.countFreeFormulaUnits(drainData.formula);
        double d3 = (double)n / (Double)this.model.solution.volume.get();
        double d4 = ((double)drainData.initialNumberFormulaUnits + 0.5) / drainData.initialVolume;
        double d5 = (double)n / ((Double)this.model.solution.volume.get() - d2 * d);
        double d6 = d5 - d3;
        double d7 = (d4 - d3) / d6;
        return d7 * d;
    }

    public void updateParticlesFlowingToDrain(DrainData drainData, double d) {
        double d2;
        if (this.model.countFreeFormulaUnits(drainData.formula) == 0) {
            return;
        }
        double d3 = this.getTimeToError(drainData, d);
        if (d3 < 0.0) {
            LOGGER.fine(this.getClass().getName() + ": timeToError = " + d3 + ", recomputing initial concentration and postponing drain");
            this.model.checkStartDrain(drainData);
            return;
        }
        ImmutableVector2D immutableVector2D = this.model.getDrainFaucetMetrics().getInputPoint();
        ItemList<Particle> itemList = this.getParticlesToDrain(drainData.formula);
        Object object = itemList.iterator();
        while (object.hasNext()) {
            Particle particle = (Particle)object.next();
            LOGGER.fine(particle.getClass() + " #" + particle.hashCode() + " x: " + particle.getPosition().getX());
            double d4 = particle.getPosition().getDistance(immutableVector2D);
            double d5 = d4 / d3;
            ImmutableVector2D immutableVector2D2 = new ImmutableVector2D(particle.getPosition(), immutableVector2D).getInstanceOfMagnitude(d5);
            particle.setUpdateStrategy(new FlowToDrainStrategy(this.model, immutableVector2D2, false));
            LOGGER.fine("i = 0, target time = " + this.model.getTime() + ", velocity = " + d5 + " nominal velocity = " + 6.0E-10);
        }
        if (!itemList.isEmpty() && (d2 = ((Particle)(object = (Particle)itemList.get(0))).getPosition().getDistance(this.model.getDrainFaucetMetrics().getInputPoint())) <= ((Particle)object).velocity.get().getMagnitude() * d + ((Particle)object).getShape().getBounds2D().getWidth() / 2.0) {
            for (Particle particle : itemList) {
                particle.setUpdateStrategy(new FlowOutOfDrainStrategy(this.model));
                this.model.freeParticles.remove(particle);
                this.model.drainedParticles.add(particle);
                particle.setPosition(this.model.getDrainFaucetMetrics().outputPoint);
                particle.velocity.set(new ImmutableVector2D(0.0, -3.0E-10));
            }
        }
    }

    public ItemList<Particle> getParticlesToDrain(Formula formula) {
        Class<? extends Particle> object2;
        Particle particle;
        ArrayList<Particle> arrayList = new ArrayList<Particle>();
        Iterator<Class<Particle>> iterator = formula.getFormulaUnit().iterator();
        while (iterator.hasNext() && (particle = this.getClosestUnused(object2 = iterator.next())) != null) {
            this.usedParticles.add(particle);
            arrayList.add(particle);
        }
        if (arrayList.size() != formula.getFormulaUnit().size()) {
            for (Particle particle2 : arrayList) {
                this.usedParticles.remove(particle2);
            }
            return new ItemList<Particle>();
        }
        return new ItemList<Particle>(arrayList);
    }

    private Particle getClosestUnused(Class<? extends Particle> clazz) {
        ArrayList<Particle> arrayList = this.model.freeParticles.filter(clazz).filter(new Function1<Particle, Boolean>(){

            @Override
            public Boolean apply(Particle particle) {
                return !Draining.this.usedParticles.contains(particle);
            }
        }).toList();
        final ImmutableVector2D immutableVector2D = this.model.getDrainFaucetMetrics().getInputPoint();
        Collections.sort(arrayList, new Comparator<Particle>(){

            @Override
            public int compare(Particle particle, Particle particle2) {
                return Double.compare(particle.getPosition().getDistance(immutableVector2D), particle2.getPosition().getDistance(immutableVector2D));
            }
        });
        if (arrayList.size() > 0) {
            return arrayList.get(0);
        }
        return null;
    }
}

