/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics;

import edu.colorado.phet.common.phetcommon.util.function.Function2;
import edu.colorado.phet.sugarandsaltsolutions.common.model.ItemList;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Particle;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.CrystallizationMatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetConfiguration<T extends Particle> {
    private final ItemList<CrystallizationMatch<T>> list;
    public final double distance;

    public TargetConfiguration(ItemList<CrystallizationMatch<T>> itemList) {
        this.list = itemList;
        this.distance = itemList.foldLeft(0.0, new Function2<CrystallizationMatch<T>, Double, Double>(){

            @Override
            public Double apply(CrystallizationMatch<T> crystallizationMatch, Double d) {
                return crystallizationMatch.distance + d;
            }
        });
    }

    public ItemList<CrystallizationMatch<T>> getMatches() {
        return this.list;
    }

    public String toString() {
        return this.list.toString();
    }
}

