/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.micro.model.sodiumnitrate;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.sugarandsaltsolutions.common.model.ItemList;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Particle;
import edu.colorado.phet.sugarandsaltsolutions.common.model.SphericalParticle;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.MicroModel;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.RandomUtil;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.AllPairs;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.CrystalGrowth;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.CrystalStrategy;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.IFormulaUnit;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.sodiumnitrate.Nitrate;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.sodiumnitrate.SodiumNitrateCrystal;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SodiumNitrateCrystalGrowth
extends CrystalGrowth<Particle, SodiumNitrateCrystal> {
    public SodiumNitrateCrystalGrowth(MicroModel microModel, ItemList<SodiumNitrateCrystal> itemList) {
        super(microModel, itemList);
    }

    @Override
    protected ArrayList<IFormulaUnit> getAllSeeds() {
        return new AllPairs(this.model.freeParticles, SphericalParticle.Sodium.class, Nitrate.class);
    }

    @Override
    protected SodiumNitrateCrystal newCrystal(ImmutableVector2D immutableVector2D) {
        return new SodiumNitrateCrystal(immutableVector2D, RandomUtil.randomAngle()){
            {
                this.setUpdateStrategy(new CrystalStrategy(SodiumNitrateCrystalGrowth.this.model, ((SodiumNitrateCrystalGrowth)SodiumNitrateCrystalGrowth.this).model.sodiumNitrateCrystals, ((SodiumNitrateCrystalGrowth)SodiumNitrateCrystalGrowth.this).model.sodiumNitrateSaturated));
            }
        };
    }
}

