/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.micro.view;

import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.piccolophet.nodes.ShadedSphereNode;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class AtomImageCache {
    public static final HashMap<Key, BufferedImage> map = new HashMap();

    public static BufferedImage getAtomImage(double d, Color color) {
        Key key = new Key(d, color);
        if (!map.containsKey(key)) {
            map.put(key, BufferedImageUtils.toBufferedImage(new ShadedSphereNode(d, color, Color.white, Color.black).toImage()));
        }
        return map.get(key);
    }

    static class Key {
        public final double diameter;
        public final Color color;

        Key(double d, Color color) {
            this.diameter = d;
            this.color = color;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Key key = (Key)object;
            return Double.compare(key.diameter, this.diameter) == 0 && this.color.equals(key.color);
        }

        public int hashCode() {
            long l = this.diameter != 0.0 ? Double.doubleToLongBits(this.diameter) : 0L;
            int n = (int)(l ^ l >>> 32);
            n = 31 * n + this.color.hashCode();
            return n;
        }
    }
}

