/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.micro.view;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.sugarandsaltsolutions.common.view.barchart.Bar;
import edu.colorado.phet.sugarandsaltsolutions.common.view.barchart.BarItem;
import edu.colorado.phet.sugarandsaltsolutions.common.view.barchart.ConcentrationBarChart;
import edu.colorado.phet.sugarandsaltsolutions.micro.view.StandardizedNodeX;
import edu.umd.cs.piccolo.PNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MicroConcentrationBarChart
extends ConcentrationBarChart {
    private final PNode barLayer = new PNode();
    private final SettableProperty<Boolean> showValues;

    public MicroConcentrationBarChart(Property<Boolean> property, SettableProperty<Boolean> settableProperty, BarItem ... barItemArray) {
        super(settableProperty, property, 0, false);
        this.addChild(this.barLayer);
        this.showValues = settableProperty;
        this.setBars(barItemArray);
    }

    public void setBars(BarItem ... barItemArray) {
        double d;
        this.barLayer.removeAllChildren();
        double d2 = d = this.background.getFullBounds().getWidth() / (double)(barItemArray.length + 1);
        for (BarItem barItem : barItemArray) {
            final double d3 = d2;
            this.barLayer.addChild(new StandardizedNodeX(new Bar(barItem.color, barItem.caption, barItem.icon.apply(), barItem.concentration, this.showValues, 0.008, true)){
                {
                    super(pNode);
                    this.setOffset(d3 - this.getFullBoundsReference().width / 2.0, MicroConcentrationBarChart.this.abscissaY);
                }
            });
            d2 += d;
        }
    }
}

