/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.micro.view.periodictable;

import edu.colorado.phet.common.phetcommon.view.PhetColorScheme;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.periodictable.BasicElementCell;
import edu.colorado.phet.common.piccolophet.nodes.periodictable.CellFactory;
import edu.colorado.phet.common.piccolophet.nodes.periodictable.ElementCell;
import edu.colorado.phet.sugarandsaltsolutions.micro.view.periodictable.PeriodicTableDialog;
import java.awt.BasicStroke;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;

public class HighlightMetals
implements CellFactory {
    private final ArrayList<Integer> nonmetals = new ArrayList<Integer>(Arrays.asList(1, 2, 5, 6, 7, 8, 9, 10, 14, 15, 16, 17, 18, 33, 34, 35, 36, 52, 53, 54, 85, 86, 118));
    private final List<Integer> selectedAtomicMasses;
    private final boolean debug = false;

    public HighlightMetals(Integer[] integerArray) {
        this.selectedAtomicMasses = Arrays.asList(integerArray);
    }

    public ElementCell createCellForElement(final int n, Color color) {
        final boolean bl = this.selectedAtomicMasses.contains(n);
        final Color color2 = this.nonmetals.contains(n) ? PeriodicTableDialog.NON_METAL_COLOR : color;
        final PhetFont phetFont = bl ? new PhetFont(PhetFont.getDefaultFontSize(), true) : new PhetFont(12);
        final BasicStroke basicStroke = bl ? new BasicStroke(3.0f) : new BasicStroke(1.0f);
        final Color color3 = bl ? PhetColorScheme.RED_COLORBLIND : Color.black;
        return new BasicElementCell(n, color2){
            {
                super(n3, color);
                if (bl) {
                    // empty if block
                }
                this.getBox().setStroke(basicStroke);
                this.getText().setFont(phetFont);
                this.getBox().setPaint(color2);
                this.getBox().setStrokePaint(color3);
            }

            public void tableInitComplete() {
                super.tableInitComplete();
                if (HighlightMetals.this.selectedAtomicMasses.contains(n)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            this.moveToFront();
                        }
                    });
                }
            }
        };
    }
}

