/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.micro.view.periodictable;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.periodictable.PeriodicTableNode;
import edu.colorado.phet.sugarandsaltsolutions.SugarAndSaltSolutionsColorScheme;
import edu.colorado.phet.sugarandsaltsolutions.common.model.DispenserType;
import edu.colorado.phet.sugarandsaltsolutions.micro.view.periodictable.HighlightMetals;
import edu.colorado.phet.sugarandsaltsolutions.micro.view.periodictable.PeriodicTableLegend;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeriodicTableDialog
extends JDialog {
    public static final Color METAL_COLOR = new Color(160, 160, 160);
    public static final Color NON_METAL_COLOR = new Color(255, 195, 195);

    public PeriodicTableDialog(final Property<DispenserType> property, final SugarAndSaltSolutionsColorScheme sugarAndSaltSolutionsColorScheme, PhetFrame phetFrame) {
        super(phetFrame);
        this.setContentPane(new PhetPCanvas(){
            final PhetPCanvas canvas = this;
            private final PNode root = new PNode();
            {
                this.addWorldChild(this.root);
                sugarAndSaltSolutionsColorScheme.backgroundColorSet.color.addObserver(new VoidFunction1<Color>(){

                    @Override
                    public void apply(Color color) {
                        this.setBackground(color);
                    }
                });
                property.addObserver(new VoidFunction1<DispenserType>(){

                    @Override
                    public void apply(DispenserType dispenserType) {
                        final PeriodicTableNode periodicTableNode = new PeriodicTableNode(METAL_COLOR, new HighlightMetals(((DispenserType)property.get()).getElementAtomicMasses())){
                            {
                                this.scale(1.5);
                                this.setOffset(26.0, 26.0);
                            }
                        };
                        root.removeAllChildren();
                        root.addChild(periodicTableNode);
                        PeriodicTableLegend periodicTableLegend = new PeriodicTableLegend(periodicTableNode.getFullBounds().getWidth(), 1.5, sugarAndSaltSolutionsColorScheme.whiteBackground){
                            {
                                super(d, d2, observableProperty);
                                this.setOffset(26.0, periodicTableNode.getFullBounds().getMaxY() + 26.0);
                            }
                        };
                        root.addChild(periodicTableLegend);
                        Dimension dimension = new Dimension((int)periodicTableNode.getFullBounds().getWidth() + 52, (int)(periodicTableNode.getFullBounds().getHeight() + periodicTableLegend.getFullBounds().getHeight() + 78.0));
                        this.setWorldTransformStrategy(new PhetPCanvas.CenteredStage(canvas, dimension));
                        this.setPreferredSize(dimension);
                    }
                });
            }
        });
        this.pack();
    }
}

