/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.water.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Compound;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Constituent;
import edu.colorado.phet.sugarandsaltsolutions.common.model.SphericalParticle;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.World;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Box2DAdapter {
    public final World world;
    public final Compound<SphericalParticle> compound;
    public final ModelViewTransform transform;
    public final Body body;

    public Box2DAdapter(World world, final Compound<SphericalParticle> compound, final ModelViewTransform modelViewTransform) {
        this.world = world;
        this.compound = compound;
        this.transform = modelViewTransform;
        BodyDef bodyDef = new BodyDef(){
            {
                ImmutableVector2D immutableVector2D = modelViewTransform.modelToView(compound.getPosition());
                this.position = new Vec2((float)immutableVector2D.getX(), (float)immutableVector2D.getY());
                this.angle = (float)compound.getAngle();
                this.type = BodyType.DYNAMIC;
            }
        };
        this.body = world.createBody(bodyDef);
        this.body.setLinearDamping(1.0f);
        this.body.setAngularDamping(1.0f);
        for (int i = 0; i < compound.numberConstituents(); ++i) {
            final Constituent<SphericalParticle> constituent = compound.getConstituent(i);
            CircleShape circleShape = new CircleShape(){
                {
                    this.m_radius = (float)modelViewTransform.modelToViewDeltaX(((SphericalParticle)constituent.particle).radius);
                    ImmutableVector2D immutableVector2D = modelViewTransform.modelToViewDelta(constituent.relativePosition);
                    this.m_p.set((float)immutableVector2D.getX(), (float)immutableVector2D.getY());
                }
            };
            Fixture fixture = this.body.createFixture(circleShape, 1.0f);
            fixture.setRestitution(0.1f);
        }
    }

    public void worldStepped() {
        this.compound.setPositionAndAngle(this.transform.viewToModel(new ImmutableVector2D(this.body.getPosition().x, this.body.getPosition().y)), this.body.getAngle());
    }

    public void applyModelForce(ImmutableVector2D immutableVector2D, ImmutableVector2D immutableVector2D2) {
        ImmutableVector2D immutableVector2D3 = this.transform.modelToViewDelta(immutableVector2D);
        ImmutableVector2D immutableVector2D4 = this.transform.modelToView(immutableVector2D2);
        this.applyBox2DForce(immutableVector2D3.getX(), immutableVector2D3.getY(), immutableVector2D4);
    }

    public void applyBox2DForce(double d, double d2, ImmutableVector2D immutableVector2D) {
        this.body.applyForce(new Vec2((float)d, (float)d2), new Vec2((float)immutableVector2D.getX(), (float)immutableVector2D.getY()));
    }

    public void setModelPosition(double d, double d2) {
        this.setModelPosition(new ImmutableVector2D(d, d2));
    }

    public void setModelPosition(ImmutableVector2D immutableVector2D) {
        this.compound.setPosition(immutableVector2D);
        ImmutableVector2D immutableVector2D2 = this.transform.modelToView(immutableVector2D);
        this.body.setTransform(new Vec2((float)immutableVector2D2.getX(), (float)immutableVector2D2.getY()), (float)this.compound.getAngle());
    }

    public ImmutableVector2D getModelPosition() {
        return this.compound.getPosition();
    }
}

