/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.collision.DistanceInput;
import org.jbox2d.collision.DistanceOutput;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;

public class Distance {
    public static int GJK_CALLS = 0;
    public static int GJK_ITERS = 0;
    public static int GJK_MAX_ITERS = 20;
    private Simplex simplex = new Simplex();
    private int[] saveA = new int[3];
    private int[] saveB = new int[3];
    private Vec2 closestPoint = new Vec2();
    private Vec2 d = new Vec2();
    private Vec2 temp = new Vec2();
    private Vec2 normal = new Vec2();

    public final void distance(DistanceOutput distanceOutput, SimplexCache simplexCache, DistanceInput distanceInput) {
        float f;
        ++GJK_CALLS;
        DistanceProxy distanceProxy = distanceInput.proxyA;
        DistanceProxy distanceProxy2 = distanceInput.proxyB;
        Transform transform = distanceInput.transformA;
        Transform transform2 = distanceInput.transformB;
        this.simplex.readCache(simplexCache, distanceProxy, transform, distanceProxy2, transform2);
        SimplexVertex[] simplexVertexArray = this.simplex.vertices;
        int n = 0;
        this.simplex.getClosestPoint(this.closestPoint);
        float f2 = f = this.closestPoint.lengthSquared();
        int n2 = 0;
        while (n2 < GJK_MAX_ITERS) {
            n = this.simplex.m_count;
            for (int i = 0; i < n; ++i) {
                this.saveA[i] = simplexVertexArray[i].indexA;
                this.saveB[i] = simplexVertexArray[i].indexB;
            }
            switch (this.simplex.m_count) {
                case 1: {
                    break;
                }
                case 2: {
                    this.simplex.solve2();
                    break;
                }
                case 3: {
                    this.simplex.solve3();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (this.simplex.m_count == 3) break;
            this.simplex.getClosestPoint(this.closestPoint);
            f2 = this.closestPoint.lengthSquared();
            if (f2 >= f) {
                // empty if block
            }
            f = f2;
            this.simplex.getSearchDirection(this.d);
            if (this.d.lengthSquared() < 1.4210855E-14f) break;
            SimplexVertex simplexVertex = simplexVertexArray[this.simplex.m_count];
            Mat22.mulTransToOut(transform.R, this.d.negateLocal(), this.temp);
            simplexVertex.indexA = distanceProxy.getSupport(this.temp);
            Transform.mulToOut(transform, distanceProxy.getVertex(simplexVertex.indexA), simplexVertex.wA);
            Mat22.mulTransToOut(transform2.R, this.d.negateLocal(), this.temp);
            simplexVertex.indexB = distanceProxy2.getSupport(this.temp);
            Transform.mulToOut(transform2, distanceProxy2.getVertex(simplexVertex.indexB), simplexVertex.wB);
            simplexVertex.w.set(simplexVertex.wB).subLocal(simplexVertex.wA);
            ++n2;
            ++GJK_ITERS;
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                if (simplexVertex.indexA != this.saveA[i] || simplexVertex.indexB != this.saveB[i]) continue;
                bl = true;
                break;
            }
            if (bl) break;
            ++this.simplex.m_count;
        }
        GJK_MAX_ITERS = MathUtils.max(GJK_MAX_ITERS, n2);
        this.simplex.getWitnessPoints(distanceOutput.pointA, distanceOutput.pointB);
        distanceOutput.distance = MathUtils.distance(distanceOutput.pointA, distanceOutput.pointB);
        distanceOutput.iterations = n2;
        this.simplex.writeCache(simplexCache);
        if (distanceInput.useRadii) {
            float f3 = distanceProxy.m_radius;
            float f4 = distanceProxy2.m_radius;
            if (distanceOutput.distance > f3 + f4 && distanceOutput.distance > 1.1920929E-7f) {
                distanceOutput.distance -= f3 + f4;
                this.normal.set(distanceOutput.pointB).subLocal(distanceOutput.pointA);
                this.normal.normalize();
                this.temp.set(this.normal).mulLocal(f3);
                distanceOutput.pointA.addLocal(this.temp);
                this.temp.set(this.normal).mulLocal(f4);
                distanceOutput.pointB.subLocal(this.temp);
            } else {
                distanceOutput.pointA.addLocal(distanceOutput.pointB).mulLocal(0.5f);
                distanceOutput.pointB.set(distanceOutput.pointA);
                distanceOutput.distance = 0.0f;
            }
        }
    }

    public static class DistanceProxy {
        public final Vec2[] m_vertices = new Vec2[Settings.maxPolygonVertices];
        public int m_count;
        public float m_radius;

        public DistanceProxy() {
            for (int i = 0; i < this.m_vertices.length; ++i) {
                this.m_vertices[i] = new Vec2();
            }
            this.m_count = 0;
            this.m_radius = 0.0f;
        }

        public final void set(Shape shape) {
            switch (shape.getType()) {
                case CIRCLE: {
                    CircleShape circleShape = (CircleShape)shape;
                    this.m_vertices[0].set(circleShape.m_p);
                    this.m_count = 1;
                    this.m_radius = circleShape.m_radius;
                    break;
                }
                case POLYGON: {
                    PolygonShape polygonShape = (PolygonShape)shape;
                    this.m_count = polygonShape.m_vertexCount;
                    this.m_radius = polygonShape.m_radius;
                    for (int i = 0; i < this.m_count; ++i) {
                        this.m_vertices[i].set(polygonShape.m_vertices[i]);
                    }
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        public final int getSupport(Vec2 vec2) {
            int n = 0;
            float f = Vec2.dot(this.m_vertices[0], vec2);
            for (int i = 1; i < this.m_count; ++i) {
                float f2 = Vec2.dot(this.m_vertices[i], vec2);
                if (!(f2 > f)) continue;
                n = i;
                f = f2;
            }
            return n;
        }

        public final Vec2 getSupportVertex(Vec2 vec2) {
            int n = 0;
            float f = Vec2.dot(this.m_vertices[0], vec2);
            for (int i = 1; i < this.m_count; ++i) {
                float f2 = Vec2.dot(this.m_vertices[i], vec2);
                if (!(f2 > f)) continue;
                n = i;
                f = f2;
            }
            return this.m_vertices[n];
        }

        public final int getVertexCount() {
            return this.m_count;
        }

        public final Vec2 getVertex(int n) {
            assert (0 <= n && n < this.m_count);
            return this.m_vertices[n];
        }
    }

    private class Simplex {
        public final SimplexVertex m_v1;
        public final SimplexVertex m_v2;
        public final SimplexVertex m_v3;
        public final SimplexVertex[] vertices;
        public int m_count;
        private final Vec2 e12;
        private final Vec2 case2;
        private final Vec2 case22;
        private final Vec2 case3;
        private final Vec2 case33;
        private final Vec2 e13;
        private final Vec2 e23;
        private final Vec2 w1;
        private final Vec2 w2;
        private final Vec2 w3;

        private Simplex() {
            this.m_v1 = new SimplexVertex();
            this.m_v2 = new SimplexVertex();
            this.m_v3 = new SimplexVertex();
            this.vertices = new SimplexVertex[]{this.m_v1, this.m_v2, this.m_v3};
            this.e12 = new Vec2();
            this.case2 = new Vec2();
            this.case22 = new Vec2();
            this.case3 = new Vec2();
            this.case33 = new Vec2();
            this.e13 = new Vec2();
            this.e23 = new Vec2();
            this.w1 = new Vec2();
            this.w2 = new Vec2();
            this.w3 = new Vec2();
        }

        public void readCache(SimplexCache simplexCache, DistanceProxy distanceProxy, Transform transform, DistanceProxy distanceProxy2, Transform transform2) {
            Vec2 vec2;
            assert (simplexCache.count <= 3);
            this.m_count = simplexCache.count;
            for (int i = 0; i < this.m_count; ++i) {
                SimplexVertex simplexVertex = this.vertices[i];
                simplexVertex.indexA = simplexCache.indexA[i];
                simplexVertex.indexB = simplexCache.indexB[i];
                vec2 = distanceProxy.getVertex(simplexVertex.indexA);
                Vec2 vec22 = distanceProxy2.getVertex(simplexVertex.indexB);
                Transform.mulToOut(transform, vec2, simplexVertex.wA);
                Transform.mulToOut(transform2, vec22, simplexVertex.wB);
                simplexVertex.w.set(simplexVertex.wB).subLocal(simplexVertex.wA);
                simplexVertex.a = 0.0f;
            }
            if (this.m_count > 1) {
                float f = simplexCache.metric;
                float f2 = this.getMetric();
                if (f2 < 0.5f * f || 2.0f * f < f2 || f2 < 1.1920929E-7f) {
                    this.m_count = 0;
                }
            }
            if (this.m_count == 0) {
                SimplexVertex simplexVertex = this.vertices[0];
                simplexVertex.indexA = 0;
                simplexVertex.indexB = 0;
                Vec2 vec23 = distanceProxy.getVertex(0);
                vec2 = distanceProxy2.getVertex(0);
                Transform.mulToOut(transform, vec23, simplexVertex.wA);
                Transform.mulToOut(transform2, vec2, simplexVertex.wB);
                simplexVertex.w.set(simplexVertex.wB).subLocal(simplexVertex.wA);
                this.m_count = 1;
            }
        }

        public void writeCache(SimplexCache simplexCache) {
            simplexCache.metric = this.getMetric();
            simplexCache.count = this.m_count;
            for (int i = 0; i < this.m_count; ++i) {
                simplexCache.indexA[i] = this.vertices[i].indexA;
                simplexCache.indexB[i] = this.vertices[i].indexB;
            }
        }

        public final void getSearchDirection(Vec2 vec2) {
            switch (this.m_count) {
                case 1: {
                    vec2.set(this.m_v1.w).negateLocal();
                    return;
                }
                case 2: {
                    this.e12.set(this.m_v2.w).subLocal(this.m_v1.w);
                    vec2.set(this.m_v1.w).negateLocal();
                    float f = Vec2.cross(this.e12, vec2);
                    if (f > 0.0f) {
                        Vec2.crossToOut(1.0f, this.e12, vec2);
                        return;
                    }
                    Vec2.crossToOut(this.e12, 1.0f, vec2);
                    return;
                }
            }
            assert (false);
            vec2.setZero();
        }

        public void getClosestPoint(Vec2 vec2) {
            switch (this.m_count) {
                case 0: {
                    assert (false);
                    vec2.setZero();
                    return;
                }
                case 1: {
                    vec2.set(this.m_v1.w);
                    return;
                }
                case 2: {
                    this.case22.set(this.m_v2.w).mulLocal(this.m_v2.a);
                    this.case2.set(this.m_v1.w).mulLocal(this.m_v1.a).addLocal(this.case22);
                    vec2.set(this.case2);
                    return;
                }
                case 3: {
                    vec2.setZero();
                    return;
                }
            }
            assert (false);
            vec2.setZero();
        }

        public void getWitnessPoints(Vec2 vec2, Vec2 vec22) {
            switch (this.m_count) {
                case 0: {
                    assert (false);
                    break;
                }
                case 1: {
                    vec2.set(this.m_v1.wA);
                    vec22.set(this.m_v1.wB);
                    break;
                }
                case 2: {
                    this.case2.set(this.m_v1.wA).mulLocal(this.m_v1.a);
                    vec2.set(this.m_v2.wA).mulLocal(this.m_v2.a).addLocal(this.case2);
                    this.case2.set(this.m_v1.wB).mulLocal(this.m_v1.a);
                    vec22.set(this.m_v2.wB).mulLocal(this.m_v2.a).addLocal(this.case2);
                    break;
                }
                case 3: {
                    vec2.set(this.m_v1.wA).mulLocal(this.m_v1.a);
                    this.case3.set(this.m_v2.wA).mulLocal(this.m_v2.a);
                    this.case33.set(this.m_v3.wA).mulLocal(this.m_v3.a);
                    vec2.addLocal(this.case3).addLocal(this.case33);
                    vec22.set(vec2);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        public float getMetric() {
            switch (this.m_count) {
                case 0: {
                    assert (false);
                    return 0.0f;
                }
                case 1: {
                    return 0.0f;
                }
                case 2: {
                    return MathUtils.distance(this.m_v1.w, this.m_v2.w);
                }
                case 3: {
                    this.case3.set(this.m_v2.w).subLocal(this.m_v1.w);
                    this.case33.set(this.m_v3.w).subLocal(this.m_v1.w);
                    return Vec2.cross(this.case3, this.case33);
                }
            }
            assert (false);
            return 0.0f;
        }

        public void solve2() {
            Vec2 vec2 = this.m_v1.w;
            Vec2 vec22 = this.m_v2.w;
            this.e12.set(vec22).subLocal(vec2);
            float f = -Vec2.dot(vec2, this.e12);
            if (f <= 0.0f) {
                this.m_v1.a = 1.0f;
                this.m_count = 1;
                return;
            }
            float f2 = Vec2.dot(vec22, this.e12);
            if (f2 <= 0.0f) {
                this.m_v2.a = 1.0f;
                this.m_count = 1;
                this.m_v1.set(this.m_v2);
                return;
            }
            float f3 = 1.0f / (f2 + f);
            this.m_v1.a = f2 * f3;
            this.m_v2.a = f * f3;
            this.m_count = 2;
        }

        public void solve3() {
            float f;
            float f2;
            float f3;
            this.w1.set(this.m_v1.w);
            this.w2.set(this.m_v2.w);
            this.w3.set(this.m_v3.w);
            this.e12.set(this.w2).subLocal(this.w1);
            float f4 = Vec2.dot(this.w1, this.e12);
            float f5 = f3 = Vec2.dot(this.w2, this.e12);
            float f6 = -f4;
            this.e13.set(this.w3).subLocal(this.w1);
            float f7 = Vec2.dot(this.w1, this.e13);
            float f8 = f2 = Vec2.dot(this.w3, this.e13);
            float f9 = -f7;
            this.e23.set(this.w3).subLocal(this.w2);
            float f10 = Vec2.dot(this.w2, this.e23);
            float f11 = f = Vec2.dot(this.w3, this.e23);
            float f12 = -f10;
            float f13 = Vec2.cross(this.e12, this.e13);
            float f14 = f13 * Vec2.cross(this.w2, this.w3);
            float f15 = f13 * Vec2.cross(this.w3, this.w1);
            float f16 = f13 * Vec2.cross(this.w1, this.w2);
            if (f6 <= 0.0f && f9 <= 0.0f) {
                this.m_v1.a = 1.0f;
                this.m_count = 1;
                return;
            }
            if (f5 > 0.0f && f6 > 0.0f && f16 <= 0.0f) {
                float f17 = 1.0f / (f5 + f6);
                this.m_v1.a = f5 * f17;
                this.m_v2.a = f6 * f17;
                this.m_count = 2;
                return;
            }
            if (f8 > 0.0f && f9 > 0.0f && f15 <= 0.0f) {
                float f18 = 1.0f / (f8 + f9);
                this.m_v1.a = f8 * f18;
                this.m_v3.a = f9 * f18;
                this.m_count = 2;
                this.m_v2.set(this.m_v3);
                return;
            }
            if (f5 <= 0.0f && f12 <= 0.0f) {
                this.m_v2.a = 1.0f;
                this.m_count = 1;
                this.m_v1.set(this.m_v2);
                return;
            }
            if (f8 <= 0.0f && f11 <= 0.0f) {
                this.m_v3.a = 1.0f;
                this.m_count = 1;
                this.m_v1.set(this.m_v3);
                return;
            }
            if (f11 > 0.0f && f12 > 0.0f && f14 <= 0.0f) {
                float f19 = 1.0f / (f11 + f12);
                this.m_v2.a = f11 * f19;
                this.m_v3.a = f12 * f19;
                this.m_count = 2;
                this.m_v1.set(this.m_v3);
                return;
            }
            float f20 = 1.0f / (f14 + f15 + f16);
            this.m_v1.a = f14 * f20;
            this.m_v2.a = f15 * f20;
            this.m_v3.a = f16 * f20;
            this.m_count = 3;
        }
    }

    public static class SimplexCache {
        public float metric = 0.0f;
        public int count = 0;
        public final int[] indexA = new int[3];
        public final int[] indexB = new int[3];

        public SimplexCache() {
            this.indexA[0] = Integer.MAX_VALUE;
            this.indexA[1] = Integer.MAX_VALUE;
            this.indexA[2] = Integer.MAX_VALUE;
            this.indexB[0] = Integer.MAX_VALUE;
            this.indexB[1] = Integer.MAX_VALUE;
            this.indexB[2] = Integer.MAX_VALUE;
        }

        public void set(SimplexCache simplexCache) {
            System.arraycopy(simplexCache.indexA, 0, this.indexA, 0, this.indexA.length);
            System.arraycopy(simplexCache.indexB, 0, this.indexB, 0, this.indexB.length);
            this.metric = simplexCache.metric;
            this.count = simplexCache.count;
        }
    }

    private class SimplexVertex {
        public final Vec2 wA = new Vec2();
        public final Vec2 wB = new Vec2();
        public final Vec2 w = new Vec2();
        public float a;
        public int indexA;
        public int indexB;

        private SimplexVertex() {
        }

        public void set(SimplexVertex simplexVertex) {
            this.wA.set(simplexVertex.wA);
            this.wB.set(simplexVertex.wB);
            this.w.set(simplexVertex.w);
            this.a = simplexVertex.a;
            this.indexA = simplexVertex.indexA;
            this.indexB = simplexVertex.indexB;
        }
    }
}

