/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.collision.Distance;
import org.jbox2d.collision.DistanceInput;
import org.jbox2d.collision.DistanceOutput;
import org.jbox2d.collision.SeparationFunction;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Sweep;
import org.jbox2d.common.Transform;
import org.jbox2d.pooling.IWorldPool;

public class TimeOfImpact {
    public static final int MAX_ITERATIONS = 1000;
    public static int toiCalls = 0;
    public static int toiIters = 0;
    public static int toiMaxIters = 0;
    public static int toiRootIters = 0;
    public static int toiMaxRootIters = 0;
    private final Distance.SimplexCache cache = new Distance.SimplexCache();
    private final DistanceInput distanceInput = new DistanceInput();
    private final Transform xfA = new Transform();
    private final Transform xfB = new Transform();
    private final DistanceOutput distanceOutput = new DistanceOutput();
    private final SeparationFunction fcn = new SeparationFunction();
    private final int[] indexes = new int[2];
    private final Sweep sweepA = new Sweep();
    private final Sweep sweepB = new Sweep();
    private final IWorldPool pool;

    public TimeOfImpact(IWorldPool iWorldPool) {
        this.pool = iWorldPool;
    }

    public final void timeOfImpact(TOIOutput tOIOutput, TOIInput tOIInput) {
        int n;
        block13: {
            ++toiCalls;
            tOIOutput.state = TOIOutputState.UNKNOWN;
            tOIOutput.t = tOIInput.tMax;
            Distance.DistanceProxy distanceProxy = tOIInput.proxyA;
            Distance.DistanceProxy distanceProxy2 = tOIInput.proxyB;
            this.sweepA.set(tOIInput.sweepA);
            this.sweepB.set(tOIInput.sweepB);
            this.sweepA.normalize();
            this.sweepB.normalize();
            float f = tOIInput.tMax;
            float f2 = distanceProxy.m_radius + distanceProxy2.m_radius;
            float f3 = MathUtils.max(Settings.linearSlop, f2 - 3.0f * Settings.linearSlop);
            float f4 = 0.25f * Settings.linearSlop;
            assert (f3 > f4);
            float f5 = 0.0f;
            n = 0;
            this.cache.count = 0;
            this.distanceInput.proxyA = tOIInput.proxyA;
            this.distanceInput.proxyB = tOIInput.proxyB;
            this.distanceInput.useRadii = false;
            do {
                this.sweepA.getTransform(this.xfA, f5);
                this.sweepB.getTransform(this.xfB, f5);
                this.distanceInput.transformA = this.xfA;
                this.distanceInput.transformB = this.xfB;
                this.pool.getDistance().distance(this.distanceOutput, this.cache, this.distanceInput);
                if (this.distanceOutput.distance <= 0.0f) {
                    tOIOutput.state = TOIOutputState.OVERLAPPED;
                    tOIOutput.t = 0.0f;
                    break block13;
                }
                if (this.distanceOutput.distance < f3 + f4) {
                    tOIOutput.state = TOIOutputState.TOUCHING;
                    tOIOutput.t = f5;
                    break block13;
                }
                this.fcn.initialize(this.cache, distanceProxy, this.sweepA, distanceProxy2, this.sweepB, f5);
                boolean bl = false;
                float f6 = f;
                int n2 = 0;
                do {
                    float f7;
                    if ((f7 = this.fcn.findMinSeparation(this.indexes, f6)) > f3 + f4) {
                        tOIOutput.state = TOIOutputState.SEPARATED;
                        tOIOutput.t = f;
                        bl = true;
                        break;
                    }
                    if (f7 > f3 - f4) {
                        f5 = f6;
                        break;
                    }
                    float f8 = this.fcn.evaluate(this.indexes[0], this.indexes[1], f5);
                    if (f8 < f3 - f4) {
                        tOIOutput.state = TOIOutputState.FAILED;
                        tOIOutput.t = f5;
                        bl = true;
                        break;
                    }
                    if (f8 <= f3 + f4) {
                        tOIOutput.state = TOIOutputState.TOUCHING;
                        tOIOutput.t = f5;
                        bl = true;
                        break;
                    }
                    int n3 = 0;
                    float f9 = f5;
                    float f10 = f6;
                    do {
                        float f11;
                        float f12;
                        if (MathUtils.abs((f12 = this.fcn.evaluate(this.indexes[0], this.indexes[1], f11 = n3 & true ? f9 + (f3 - f8) * (f10 - f9) / (f7 - f8) : 0.5f * (f9 + f10))) - f3) < f4) {
                            f6 = f11;
                            break;
                        }
                        if (f12 > f3) {
                            f9 = f11;
                            f8 = f12;
                        } else {
                            f10 = f11;
                            f7 = f12;
                        }
                        ++toiRootIters;
                    } while (++n3 != 50);
                    toiMaxRootIters = MathUtils.max(toiMaxRootIters, n3);
                } while (++n2 != Settings.maxPolygonVertices);
                ++n;
                ++toiIters;
                if (bl) break block13;
            } while (n != 1000);
            tOIOutput.state = TOIOutputState.FAILED;
            tOIOutput.t = f5;
        }
        toiMaxIters = MathUtils.max(toiMaxIters, n);
    }

    public static class TOIInput {
        public final Distance.DistanceProxy proxyA = new Distance.DistanceProxy();
        public final Distance.DistanceProxy proxyB = new Distance.DistanceProxy();
        public final Sweep sweepA = new Sweep();
        public final Sweep sweepB = new Sweep();
        public float tMax;
    }

    public static class TOIOutput {
        public TOIOutputState state;
        public float t;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TOIOutputState {
        UNKNOWN,
        FAILED,
        OVERLAPPED,
        TOUCHING,
        SEPARATED;

    }
}

