/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.collision.Manifold;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;

public class WorldManifold {
    public final Vec2 normal;
    public final Vec2[] points;
    private final Vec2 pool3 = new Vec2();
    private final Vec2 pool4 = new Vec2();

    public WorldManifold() {
        this.normal = new Vec2();
        this.points = new Vec2[Settings.maxManifoldPoints];
        for (int i = 0; i < Settings.maxManifoldPoints; ++i) {
            this.points[i] = new Vec2();
        }
    }

    public final void initialize(Manifold manifold, Transform transform, float f, Transform transform2, float f2) {
        if (manifold.pointCount == 0) {
            return;
        }
        switch (manifold.type) {
            case CIRCLES: {
                Vec2 vec2 = this.pool3;
                Vec2 vec22 = this.pool4;
                this.normal.x = 1.0f;
                this.normal.y = 0.0f;
                vec2.x = transform.position.x + transform.R.col1.x * manifold.localPoint.x + transform.R.col2.x * manifold.localPoint.y;
                vec2.y = transform.position.y + transform.R.col1.y * manifold.localPoint.x + transform.R.col2.y * manifold.localPoint.y;
                vec22.x = transform2.position.x + transform2.R.col1.x * manifold.points[0].localPoint.x + transform2.R.col2.x * manifold.points[0].localPoint.y;
                vec22.y = transform2.position.y + transform2.R.col1.y * manifold.points[0].localPoint.x + transform2.R.col2.y * manifold.points[0].localPoint.y;
                if (MathUtils.distanceSquared(vec2, vec22) > 1.4210855E-14f) {
                    this.normal.x = vec22.x - vec2.x;
                    this.normal.y = vec22.y - vec2.y;
                    this.normal.normalize();
                }
                float f3 = this.normal.x * f + vec2.x;
                float f4 = this.normal.y * f + vec2.y;
                float f5 = -this.normal.x * f2 + vec22.x;
                float f6 = -this.normal.y * f2 + vec22.y;
                this.points[0].x = (f3 + f5) * 0.5f;
                this.points[0].y = (f4 + f6) * 0.5f;
                break;
            }
            case FACE_A: {
                Vec2 vec2 = this.pool3;
                this.normal.x = transform.R.col1.x * manifold.localNormal.x + transform.R.col2.x * manifold.localNormal.y;
                this.normal.y = transform.R.col1.y * manifold.localNormal.x + transform.R.col2.y * manifold.localNormal.y;
                vec2.x = transform.position.x + transform.R.col1.x * manifold.localPoint.x + transform.R.col2.x * manifold.localPoint.y;
                vec2.y = transform.position.y + transform.R.col1.y * manifold.localPoint.x + transform.R.col2.y * manifold.localPoint.y;
                Vec2 vec23 = this.pool4;
                for (int i = 0; i < manifold.pointCount; ++i) {
                    vec23.x = transform2.position.x + transform2.R.col1.x * manifold.points[i].localPoint.x + transform2.R.col2.x * manifold.points[i].localPoint.y;
                    vec23.y = transform2.position.y + transform2.R.col1.y * manifold.points[i].localPoint.x + transform2.R.col2.y * manifold.points[i].localPoint.y;
                    float f7 = f - ((vec23.x - vec2.x) * this.normal.x + (vec23.y - vec2.y) * this.normal.y);
                    float f8 = this.normal.x * f7 + vec23.x;
                    float f9 = this.normal.y * f7 + vec23.y;
                    float f10 = -this.normal.x * f2 + vec23.x;
                    float f11 = -this.normal.y * f2 + vec23.y;
                    this.points[i].x = (f8 + f10) * 0.5f;
                    this.points[i].y = (f9 + f11) * 0.5f;
                }
                break;
            }
            case FACE_B: {
                Vec2 vec2 = this.pool3;
                Mat22 mat22 = transform2.R;
                this.normal.x = mat22.col1.x * manifold.localNormal.x + mat22.col2.x * manifold.localNormal.y;
                this.normal.y = mat22.col1.y * manifold.localNormal.x + mat22.col2.y * manifold.localNormal.y;
                Vec2 vec24 = manifold.localPoint;
                vec2.x = transform2.position.x + transform2.R.col1.x * vec24.x + transform2.R.col2.x * vec24.y;
                vec2.y = transform2.position.y + transform2.R.col1.y * vec24.x + transform2.R.col2.y * vec24.y;
                Vec2 vec25 = this.pool4;
                for (int i = 0; i < manifold.pointCount; ++i) {
                    vec25.x = transform.position.x + transform.R.col1.x * manifold.points[i].localPoint.x + transform.R.col2.x * manifold.points[i].localPoint.y;
                    vec25.y = transform.position.y + transform.R.col1.y * manifold.points[i].localPoint.x + transform.R.col2.y * manifold.points[i].localPoint.y;
                    float f12 = f2 - ((vec25.x - vec2.x) * this.normal.x + (vec25.y - vec2.y) * this.normal.y);
                    float f13 = this.normal.x * f12 + vec25.x;
                    float f14 = this.normal.y * f12 + vec25.y;
                    float f15 = -this.normal.x * f + vec25.x;
                    float f16 = -this.normal.y * f + vec25.y;
                    this.points[i].x = (f15 + f13) * 0.5f;
                    this.points[i].y = (f16 + f14) * 0.5f;
                }
                this.normal.x = -this.normal.x;
                this.normal.y = -this.normal.y;
            }
        }
    }
}

