/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.broadphase;

import java.util.Arrays;
import org.jbox2d.callbacks.DebugDraw;
import org.jbox2d.callbacks.PairCallback;
import org.jbox2d.callbacks.TreeCallback;
import org.jbox2d.callbacks.TreeRayCastCallback;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.broadphase.DynamicTree;
import org.jbox2d.collision.broadphase.DynamicTreeNode;
import org.jbox2d.collision.broadphase.Pair;
import org.jbox2d.common.Vec2;

public class BroadPhase
implements TreeCallback {
    public static final int NULL_PROXY = -1;
    private final DynamicTree m_tree;
    private int m_proxyCount = 0;
    private DynamicTreeNode[] m_moveBuffer;
    private int m_moveCapacity;
    private int m_moveCount;
    private Pair[] m_pairBuffer = new Pair[this.m_pairCapacity];
    private int m_pairCapacity = 16;
    private int m_pairCount = 0;
    private DynamicTreeNode m_queryProxy;

    public BroadPhase() {
        for (int i = 0; i < this.m_pairCapacity; ++i) {
            this.m_pairBuffer[i] = new Pair();
        }
        this.m_moveCapacity = 16;
        this.m_moveCount = 0;
        this.m_moveBuffer = new DynamicTreeNode[this.m_moveCapacity];
        this.m_tree = new DynamicTree();
        this.m_queryProxy = null;
    }

    public final DynamicTreeNode createProxy(AABB aABB, Object object) {
        DynamicTreeNode dynamicTreeNode = this.m_tree.createProxy(aABB, object);
        ++this.m_proxyCount;
        this.bufferMove(dynamicTreeNode);
        return dynamicTreeNode;
    }

    public final void destroyProxy(DynamicTreeNode dynamicTreeNode) {
        this.unbufferMove(dynamicTreeNode);
        --this.m_proxyCount;
        this.m_tree.destroyProxy(dynamicTreeNode);
    }

    public final void moveProxy(DynamicTreeNode dynamicTreeNode, AABB aABB, Vec2 vec2) {
        boolean bl = this.m_tree.moveProxy(dynamicTreeNode, aABB, vec2);
        if (bl) {
            this.bufferMove(dynamicTreeNode);
        }
    }

    public boolean testOverlap(DynamicTreeNode dynamicTreeNode, DynamicTreeNode dynamicTreeNode2) {
        AABB aABB = dynamicTreeNode.aabb;
        AABB aABB2 = dynamicTreeNode2.aabb;
        if (aABB2.lowerBound.x - aABB.upperBound.x > 0.0f || aABB2.lowerBound.y - aABB.upperBound.y > 0.0f) {
            return false;
        }
        return !(aABB.lowerBound.x - aABB2.upperBound.x > 0.0f) && !(aABB.lowerBound.y - aABB2.upperBound.y > 0.0f);
    }

    public final int getProxyCount() {
        return this.m_proxyCount;
    }

    public void drawTree(DebugDraw debugDraw) {
        this.m_tree.drawTree(debugDraw);
    }

    public final void updatePairs(PairCallback pairCallback) {
        int n;
        this.m_pairCount = 0;
        for (n = 0; n < this.m_moveCount; ++n) {
            this.m_queryProxy = this.m_moveBuffer[n];
            if (this.m_queryProxy == null) continue;
            this.m_tree.query(this, this.m_queryProxy.aabb);
        }
        this.m_moveCount = 0;
        Arrays.sort(this.m_pairBuffer, 0, this.m_pairCount);
        n = 0;
        block1: while (n < this.m_pairCount) {
            Pair pair = this.m_pairBuffer[n];
            Object object = pair.proxyA.userData;
            Object object2 = pair.proxyB.userData;
            pairCallback.addPair(object, object2);
            ++n;
            while (n < this.m_pairCount) {
                Pair pair2 = this.m_pairBuffer[n];
                if (pair2.proxyA != pair.proxyA || pair2.proxyB != pair.proxyB) continue block1;
                ++n;
            }
        }
        this.m_tree.rebalance(4);
    }

    public final void query(TreeCallback treeCallback, AABB aABB) {
        this.m_tree.query(treeCallback, aABB);
    }

    public final void raycast(TreeRayCastCallback treeRayCastCallback, RayCastInput rayCastInput) {
        this.m_tree.raycast(treeRayCastCallback, rayCastInput);
    }

    public final int computeHeight() {
        return this.m_tree.computeHeight();
    }

    protected final void bufferMove(DynamicTreeNode dynamicTreeNode) {
        if (this.m_moveCount == this.m_moveCapacity) {
            DynamicTreeNode[] dynamicTreeNodeArray = this.m_moveBuffer;
            this.m_moveCapacity *= 2;
            this.m_moveBuffer = new DynamicTreeNode[this.m_moveCapacity];
            for (int i = 0; i < dynamicTreeNodeArray.length; ++i) {
                this.m_moveBuffer[i] = dynamicTreeNodeArray[i];
            }
        }
        this.m_moveBuffer[this.m_moveCount] = dynamicTreeNode;
        ++this.m_moveCount;
    }

    protected final void unbufferMove(DynamicTreeNode dynamicTreeNode) {
        for (int i = 0; i < this.m_moveCount; ++i) {
            if (this.m_moveBuffer[i] != dynamicTreeNode) continue;
            this.m_moveBuffer[i] = null;
            return;
        }
    }

    public final boolean treeCallback(DynamicTreeNode dynamicTreeNode) {
        if (dynamicTreeNode == this.m_queryProxy) {
            return true;
        }
        if (this.m_pairCount == this.m_pairCapacity) {
            int n;
            Pair[] pairArray = this.m_pairBuffer;
            this.m_pairCapacity *= 2;
            this.m_pairBuffer = new Pair[this.m_pairCapacity];
            for (n = 0; n < pairArray.length; ++n) {
                this.m_pairBuffer[n] = pairArray[n];
            }
            for (n = pairArray.length; n < this.m_pairCapacity; ++n) {
                this.m_pairBuffer[n] = new Pair();
            }
        }
        if (dynamicTreeNode.key < this.m_queryProxy.key) {
            this.m_pairBuffer[this.m_pairCount].proxyA = dynamicTreeNode;
            this.m_pairBuffer[this.m_pairCount].proxyB = this.m_queryProxy;
        } else {
            this.m_pairBuffer[this.m_pairCount].proxyA = this.m_queryProxy;
            this.m_pairBuffer[this.m_pairCount].proxyB = dynamicTreeNode;
        }
        ++this.m_pairCount;
        return true;
    }
}

