/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.shapes;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.RayCastOutput;
import org.jbox2d.collision.shapes.MassData;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;

public class CircleShape
extends Shape {
    public final Vec2 m_p;
    private final Vec2 pool1 = new Vec2();
    private final Vec2 pool2 = new Vec2();
    private final Vec2 pool3 = new Vec2();

    public CircleShape() {
        this.m_type = ShapeType.CIRCLE;
        this.m_p = new Vec2();
        this.m_radius = 0.0f;
    }

    public final Shape clone() {
        CircleShape circleShape = new CircleShape();
        circleShape.m_p.set(this.m_p);
        circleShape.m_radius = this.m_radius;
        return circleShape;
    }

    public final int getSupport(Vec2 vec2) {
        return 0;
    }

    public final Vec2 getSupportVertex(Vec2 vec2) {
        return this.m_p;
    }

    public final int getVertexCount() {
        return 1;
    }

    public final Vec2 getVertex(int n) {
        assert (n == 0);
        return this.m_p;
    }

    public final boolean testPoint(Transform transform, Vec2 vec2) {
        Vec2 vec22 = this.pool1;
        Mat22.mulToOut(transform.R, this.m_p, vec22);
        vec22.addLocal(transform.position);
        Vec2 vec23 = vec22.subLocal(vec2).negateLocal();
        return Vec2.dot(vec23, vec23) <= this.m_radius * this.m_radius;
    }

    public final boolean raycast(RayCastOutput rayCastOutput, RayCastInput rayCastInput, Transform transform) {
        Vec2 vec2 = this.pool1;
        Vec2 vec22 = this.pool2;
        Vec2 vec23 = this.pool3;
        Mat22.mulToOut(transform.R, this.m_p, vec2);
        vec2.addLocal(transform.position);
        vec22.set(rayCastInput.p1).subLocal(vec2);
        float f = Vec2.dot(vec22, vec22) - this.m_radius * this.m_radius;
        vec23.set(rayCastInput.p2).subLocal(rayCastInput.p1);
        float f2 = Vec2.dot(vec22, vec23);
        float f3 = Vec2.dot(vec23, vec23);
        float f4 = f2 * f2 - f3 * f;
        if (f4 < 0.0f || f3 < 1.1920929E-7f) {
            return false;
        }
        float f5 = -(f2 + MathUtils.sqrt(f4));
        if (0.0f <= f5 && f5 <= rayCastInput.maxFraction * f3) {
            rayCastOutput.fraction = f5 /= f3;
            rayCastOutput.normal.set(vec23).mulLocal(f5);
            rayCastOutput.normal.addLocal(vec22);
            rayCastOutput.normal.normalize();
            return true;
        }
        return false;
    }

    public final void computeAABB(AABB aABB, Transform transform) {
        Vec2 vec2 = this.pool1;
        Mat22.mulToOut(transform.R, this.m_p, vec2);
        vec2.addLocal(transform.position);
        aABB.lowerBound.x = vec2.x - this.m_radius;
        aABB.lowerBound.y = vec2.y - this.m_radius;
        aABB.upperBound.x = vec2.x + this.m_radius;
        aABB.upperBound.y = vec2.y + this.m_radius;
    }

    public final void computeMass(MassData massData, float f) {
        massData.mass = f * (float)Math.PI * this.m_radius * this.m_radius;
        massData.center.set(this.m_p);
        massData.I = massData.mass * (0.5f * this.m_radius * this.m_radius + Vec2.dot(this.m_p, this.m_p));
    }
}

