/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.shapes;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.RayCastOutput;
import org.jbox2d.collision.shapes.MassData;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;

public class PolygonShape
extends Shape {
    private static boolean m_debug = false;
    public final Vec2 m_centroid = new Vec2();
    public final Vec2[] m_vertices;
    public final Vec2[] m_normals;
    public int m_vertexCount;
    private final Vec2 pool1 = new Vec2();
    private final Vec2 pool2 = new Vec2();
    private final Vec2 pool3 = new Vec2();
    private final Vec2 pool4 = new Vec2();
    private final Vec2 pool5 = new Vec2();
    private final Vec2 pool6 = new Vec2();
    private Transform poolt1 = new Transform();

    public PolygonShape() {
        int n;
        this.m_type = ShapeType.POLYGON;
        this.m_vertexCount = 0;
        this.m_vertices = new Vec2[Settings.maxPolygonVertices];
        for (n = 0; n < this.m_vertices.length; ++n) {
            this.m_vertices[n] = new Vec2();
        }
        this.m_normals = new Vec2[Settings.maxPolygonVertices];
        for (n = 0; n < this.m_normals.length; ++n) {
            this.m_normals[n] = new Vec2();
        }
        this.m_radius = Settings.polygonRadius;
        this.m_centroid.setZero();
    }

    public final Shape clone() {
        PolygonShape polygonShape = new PolygonShape();
        polygonShape.m_centroid.set(this.m_centroid);
        for (int i = 0; i < polygonShape.m_normals.length; ++i) {
            polygonShape.m_normals[i].set(this.m_normals[i]);
            polygonShape.m_vertices[i].set(this.m_vertices[i]);
        }
        polygonShape.m_radius = this.m_radius;
        polygonShape.m_vertexCount = this.m_vertexCount;
        return polygonShape;
    }

    public final int getSupport(Vec2 vec2) {
        int n = 0;
        float f = Vec2.dot(this.m_vertices[0], vec2);
        for (int i = 1; i < this.m_vertexCount; ++i) {
            float f2 = Vec2.dot(this.m_vertices[i], vec2);
            if (!(f2 > f)) continue;
            n = i;
            f = f2;
        }
        return n;
    }

    public final Vec2 getSupportVertex(Vec2 vec2) {
        int n = 0;
        float f = Vec2.dot(this.m_vertices[0], vec2);
        for (int i = 1; i < this.m_vertexCount; ++i) {
            float f2 = Vec2.dot(this.m_vertices[i], vec2);
            if (!(f2 > f)) continue;
            n = i;
            f = f2;
        }
        return this.m_vertices[n];
    }

    public final void set(Vec2[] vec2Array, int n) {
        int n2;
        int n3;
        assert (2 <= n && n <= Settings.maxPolygonVertices);
        this.m_vertexCount = n;
        for (int i = 0; i < this.m_vertexCount; ++i) {
            if (this.m_vertices[i] == null) {
                this.m_vertices[i] = new Vec2();
            }
            this.m_vertices[i].set(vec2Array[i]);
        }
        Vec2 vec2 = this.pool1;
        for (int i = 0; i < this.m_vertexCount; ++i) {
            n3 = i;
            n2 = i + 1 < this.m_vertexCount ? i + 1 : 0;
            vec2.set(this.m_vertices[n2]).subLocal(this.m_vertices[n3]);
            assert (vec2.lengthSquared() > 1.4210855E-14f);
            Vec2.crossToOut(vec2, 1.0f, this.m_normals[i]);
            this.m_normals[i].normalize();
        }
        if (m_debug) {
            Vec2 vec22 = this.pool2;
            for (n3 = 0; n3 < this.m_vertexCount; ++n3) {
                n2 = n3;
                int n4 = n3 + 1 < this.m_vertexCount ? n3 + 1 : 0;
                vec2.set(this.m_vertices[n4]).subLocal(this.m_vertices[n2]);
                for (int i = 0; i < this.m_vertexCount; ++i) {
                    if (i == n2 || i == n4) continue;
                    vec22.set(this.m_vertices[i]).subLocal(this.m_vertices[n2]);
                    float f = Vec2.cross(vec2, vec22);
                    assert (f > 0.0f);
                }
            }
        }
        this.computeCentroidToOut(this.m_vertices, this.m_vertexCount, this.m_centroid);
    }

    public final void setAsBox(float f, float f2) {
        this.m_vertexCount = 4;
        this.m_vertices[0].set(-f, -f2);
        this.m_vertices[1].set(f, -f2);
        this.m_vertices[2].set(f, f2);
        this.m_vertices[3].set(-f, f2);
        this.m_normals[0].set(0.0f, -1.0f);
        this.m_normals[1].set(1.0f, 0.0f);
        this.m_normals[2].set(0.0f, 1.0f);
        this.m_normals[3].set(-1.0f, 0.0f);
        this.m_centroid.setZero();
    }

    public final void setAsBox(float f, float f2, Vec2 vec2, float f3) {
        this.m_vertexCount = 4;
        this.m_vertices[0].set(-f, -f2);
        this.m_vertices[1].set(f, -f2);
        this.m_vertices[2].set(f, f2);
        this.m_vertices[3].set(-f, f2);
        this.m_normals[0].set(0.0f, -1.0f);
        this.m_normals[1].set(1.0f, 0.0f);
        this.m_normals[2].set(0.0f, 1.0f);
        this.m_normals[3].set(-1.0f, 0.0f);
        this.m_centroid.set(vec2);
        Transform transform = this.poolt1;
        transform.position.set(vec2);
        transform.R.set(f3);
        for (int i = 0; i < this.m_vertexCount; ++i) {
            Transform.mulToOut(transform, this.m_vertices[i], this.m_vertices[i]);
            Mat22.mulToOut(transform.R, this.m_normals[i], this.m_normals[i]);
        }
    }

    public final void setAsEdge(Vec2 vec2, Vec2 vec22) {
        this.m_vertexCount = 2;
        this.m_vertices[0].set(vec2);
        this.m_vertices[1].set(vec22);
        this.m_centroid.set(vec2).addLocal(vec22).mulLocal(0.5f);
        this.m_normals[0].set(vec22).subLocal(vec2);
        Vec2.crossToOut(this.m_normals[0], 1.0f, this.m_normals[0]);
        this.m_normals[0].normalize();
        this.m_normals[1].set(this.m_normals[0]).negateLocal();
    }

    public final boolean testPoint(Transform transform, Vec2 vec2) {
        Vec2 vec22 = this.pool1;
        vec22.set(vec2).subLocal(transform.position);
        Mat22.mulTransToOut(transform.R, vec22, vec22);
        if (m_debug) {
            System.out.println("--testPoint debug--");
            System.out.println("Vertices: ");
            for (int i = 0; i < this.m_vertexCount; ++i) {
                System.out.println(this.m_vertices[i]);
            }
            System.out.println("pLocal: " + vec22);
        }
        Vec2 vec23 = this.pool2;
        for (int i = 0; i < this.m_vertexCount; ++i) {
            vec23.set(vec22).subLocal(this.m_vertices[i]);
            float f = Vec2.dot(this.m_normals[i], vec23);
            if (!(f > 0.0f)) continue;
            return false;
        }
        return true;
    }

    public final void computeAABB(AABB aABB, Transform transform) {
        Vec2 vec2 = this.pool1;
        Vec2 vec22 = this.pool2;
        Vec2 vec23 = this.pool3;
        Transform.mulToOut(transform, this.m_vertices[0], vec2);
        vec22.set(vec2);
        for (int i = 1; i < this.m_vertexCount; ++i) {
            Transform.mulToOut(transform, this.m_vertices[i], vec23);
            Vec2.minToOut(vec2, vec23, vec2);
            Vec2.maxToOut(vec22, vec23, vec22);
        }
        aABB.lowerBound.x = vec2.x - this.m_radius;
        aABB.lowerBound.y = vec2.y - this.m_radius;
        aABB.upperBound.x = vec22.x + this.m_radius;
        aABB.upperBound.y = vec22.y + this.m_radius;
    }

    public final int getVertexCount() {
        return this.m_vertexCount;
    }

    public final Vec2 getVertex(int n) {
        assert (0 <= n && n < this.m_vertexCount);
        return this.m_vertices[n];
    }

    public final boolean raycast(RayCastOutput rayCastOutput, RayCastInput rayCastInput, Transform transform) {
        Vec2 vec2 = this.pool1;
        Vec2 vec22 = this.pool2;
        Vec2 vec23 = this.pool3;
        Vec2 vec24 = this.pool4;
        vec2.set(rayCastInput.p1).subLocal(transform.position);
        Mat22.mulTransToOut(transform.R, vec2, vec2);
        vec22.set(rayCastInput.p2).subLocal(transform.position);
        Mat22.mulTransToOut(transform.R, vec22, vec22);
        vec23.set(vec22).subLocal(vec2);
        if (this.m_vertexCount == 2) {
            Vec2 vec25 = this.m_vertices[0];
            Vec2 vec26 = this.m_vertices[1];
            Vec2 vec27 = this.m_normals[0];
            vec24.set(vec25).subLocal(vec2);
            float f = Vec2.dot(vec27, vec24);
            float f2 = Vec2.dot(vec27, vec23);
            if (f2 == 0.0f) {
                return false;
            }
            float f3 = f / f2;
            if (f3 < 0.0f || 1.0f < f3) {
                return false;
            }
            Vec2 vec28 = this.pool5;
            Vec2 vec29 = this.pool6;
            vec24.set(vec23).mulLocal(f3);
            vec28.set(vec2).addLocal(vec24);
            vec29.set(vec26).subLocal(vec25);
            float f4 = Vec2.dot(vec29, vec29);
            if (f4 == 0.0f) {
                return false;
            }
            vec24.set(vec28).subLocal(vec25);
            float f5 = Vec2.dot(vec24, vec29) / f4;
            if (f5 < 0.0f || 1.0f < f5) {
                return false;
            }
            rayCastOutput.fraction = f3;
            if (f > 0.0f) {
                rayCastOutput.normal.set(vec27).mulLocal(-1.0f);
            } else {
                rayCastOutput.normal.set(vec27);
            }
            return true;
        }
        float f = 0.0f;
        float f6 = rayCastInput.maxFraction;
        int n = -1;
        for (int i = 0; i < this.m_vertexCount; ++i) {
            vec24.set(this.m_vertices[i]).subLocal(vec2);
            float f7 = Vec2.dot(this.m_normals[i], vec24);
            float f8 = Vec2.dot(this.m_normals[i], vec23);
            if (f8 == 0.0f) {
                if (f7 < 0.0f) {
                    return false;
                }
            } else if (f8 < 0.0f && f7 < f * f8) {
                f = f7 / f8;
                n = i;
            } else if (f8 > 0.0f && f7 < f6 * f8) {
                f6 = f7 / f8;
            }
            if (!(f6 < f)) continue;
            return false;
        }
        assert (0.0f <= f && f <= rayCastInput.maxFraction);
        if (n >= 0) {
            rayCastOutput.fraction = f;
            Mat22.mulToOut(transform.R, this.m_normals[n], rayCastOutput.normal);
            return true;
        }
        return false;
    }

    public final void computeCentroidToOut(Vec2[] vec2Array, int n, Vec2 vec2) {
        assert (n >= 3);
        vec2.set(0.0f, 0.0f);
        float f = 0.0f;
        if (n == 2) {
            vec2.set(vec2Array[0]).addLocal(vec2Array[1]).mulLocal(0.5f);
            return;
        }
        Vec2 vec22 = this.pool1;
        vec22.setZero();
        Vec2 vec23 = this.pool2;
        Vec2 vec24 = this.pool3;
        for (int i = 0; i < n; ++i) {
            Vec2 vec25 = vec22;
            Vec2 vec26 = vec2Array[i];
            Vec2 vec27 = i + 1 < n ? vec2Array[i + 1] : vec2Array[0];
            vec23.set(vec26).subLocal(vec25);
            vec24.set(vec27).subLocal(vec25);
            float f2 = Vec2.cross(vec23, vec24);
            float f3 = 0.5f * f2;
            f += f3;
            vec2.addLocal(vec25).addLocal(vec26).addLocal(vec27).mulLocal(f3 * 0.33333334f);
        }
        assert (f > 1.1920929E-7f);
        vec2.mulLocal(1.0f / f);
    }

    public void computeMass(MassData massData, float f) {
        assert (this.m_vertexCount >= 2);
        if (this.m_vertexCount == 2) {
            massData.center.set(this.m_vertices[0]).addLocal(this.m_vertices[1]).mulLocal(0.5f);
            massData.mass = 0.0f;
            massData.I = 0.0f;
            return;
        }
        Vec2 vec2 = this.pool1;
        vec2.setZero();
        float f2 = 0.0f;
        float f3 = 0.0f;
        Vec2 vec22 = this.pool2;
        vec22.setZero();
        Vec2 vec23 = this.pool3;
        Vec2 vec24 = this.pool4;
        for (int i = 0; i < this.m_vertexCount; ++i) {
            Vec2 vec25 = vec22;
            Vec2 vec26 = this.m_vertices[i];
            Vec2 vec27 = i + 1 < this.m_vertexCount ? this.m_vertices[i + 1] : this.m_vertices[0];
            vec23.set(vec26);
            vec23.subLocal(vec25);
            vec24.set(vec27);
            vec24.subLocal(vec25);
            float f4 = Vec2.cross(vec23, vec24);
            float f5 = 0.5f * f4;
            f2 += f5;
            vec2.x += f5 * 0.33333334f * (vec25.x + vec26.x + vec27.x);
            vec2.y += f5 * 0.33333334f * (vec25.y + vec26.y + vec27.y);
            float f6 = vec25.x;
            float f7 = vec25.y;
            float f8 = vec23.x;
            float f9 = vec23.y;
            float f10 = vec24.x;
            float f11 = vec24.y;
            float f12 = 0.33333334f * (0.25f * (f8 * f8 + f10 * f8 + f10 * f10) + (f6 * f8 + f6 * f10)) + 0.5f * f6 * f6;
            float f13 = 0.33333334f * (0.25f * (f9 * f9 + f11 * f9 + f11 * f11) + (f7 * f9 + f7 * f11)) + 0.5f * f7 * f7;
            f3 += f4 * (f12 + f13);
        }
        massData.mass = f * f2;
        assert (f2 > 1.1920929E-7f);
        vec2.mulLocal(1.0f / f2);
        massData.center.set(vec2);
        massData.I = f3 * f;
    }

    public Vec2[] getVertices() {
        return this.m_vertices;
    }

    public Vec2[] getNormals() {
        return this.m_normals;
    }

    public Vec2 centroid(Transform transform) {
        return Transform.mul(transform, this.m_centroid);
    }

    public Vec2 centroidToOut(Transform transform, Vec2 vec2) {
        Transform.mulToOut(transform, this.m_centroid, vec2);
        return vec2;
    }
}

