/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.common;

import java.io.Serializable;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;

public class Mat22
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final Vec2 col1;
    public final Vec2 col2;

    public String toString() {
        String string = "";
        string = string + "[" + this.col1.x + "," + this.col2.x + "]\n";
        string = string + "[" + this.col1.y + "," + this.col2.y + "]";
        return string;
    }

    public Mat22() {
        this.col1 = new Vec2();
        this.col2 = new Vec2();
    }

    public Mat22(Vec2 vec2, Vec2 vec22) {
        this.col1 = vec2.clone();
        this.col2 = vec22.clone();
    }

    public Mat22(float f, float f2, float f3, float f4) {
        this.col1 = new Vec2(f, f3);
        this.col2 = new Vec2(f2, f4);
    }

    public final Mat22 set(Mat22 mat22) {
        this.col1.x = mat22.col1.x;
        this.col1.y = mat22.col1.y;
        this.col2.x = mat22.col2.x;
        this.col2.y = mat22.col2.y;
        return this;
    }

    public final Mat22 set(float f, float f2, float f3, float f4) {
        this.col1.x = f;
        this.col1.y = f3;
        this.col2.x = f2;
        this.col2.y = f4;
        return this;
    }

    public final Mat22 clone() {
        return new Mat22(this.col1, this.col2);
    }

    public final void set(float f) {
        float f2 = MathUtils.cos(f);
        float f3 = MathUtils.sin(f);
        this.col1.x = f2;
        this.col2.x = -f3;
        this.col1.y = f3;
        this.col2.y = f2;
    }

    public final void setIdentity() {
        this.col1.x = 1.0f;
        this.col2.x = 0.0f;
        this.col1.y = 0.0f;
        this.col2.y = 1.0f;
    }

    public final void setZero() {
        this.col1.x = 0.0f;
        this.col2.x = 0.0f;
        this.col1.y = 0.0f;
        this.col2.y = 0.0f;
    }

    public final float getAngle() {
        return MathUtils.atan2(this.col1.y, this.col1.x);
    }

    public final void set(Vec2 vec2, Vec2 vec22) {
        this.col1.x = vec2.x;
        this.col2.x = vec22.x;
        this.col1.y = vec2.y;
        this.col2.y = vec22.y;
    }

    public final Mat22 invert() {
        float f = this.col1.x;
        float f2 = this.col2.x;
        float f3 = this.col1.y;
        float f4 = this.col2.y;
        Mat22 mat22 = new Mat22();
        float f5 = f * f4 - f2 * f3;
        if (f5 != 0.0f) {
            f5 = 1.0f / f5;
        }
        mat22.col1.x = f5 * f4;
        mat22.col2.x = -f5 * f2;
        mat22.col1.y = -f5 * f3;
        mat22.col2.y = f5 * f;
        return mat22;
    }

    public final Mat22 invertLocal() {
        float f = this.col1.x;
        float f2 = this.col2.y;
        float f3 = this.col2.x;
        float f4 = this.col1.y;
        float f5 = f * f2 - f3 * f4;
        if (f5 != 0.0f) {
            f5 = 1.0f / f5;
        }
        this.col1.x = f5 * f2;
        this.col2.x = -f5 * f3;
        this.col1.y = -f5 * f4;
        this.col2.y = f5 * f;
        return this;
    }

    public final void invertToOut(Mat22 mat22) {
        float f = this.col1.x;
        float f2 = this.col2.x;
        float f3 = this.col1.y;
        float f4 = this.col2.y;
        float f5 = f * f4 - f2 * f3;
        f5 = 1.0f / f5;
        mat22.col1.x = f5 * f4;
        mat22.col2.x = -f5 * f2;
        mat22.col1.y = -f5 * f3;
        mat22.col2.y = f5 * f;
    }

    public final Mat22 abs() {
        return new Mat22(MathUtils.abs(this.col1.x), MathUtils.abs(this.col2.x), MathUtils.abs(this.col1.y), MathUtils.abs(this.col2.y));
    }

    public final void absLocal() {
        this.col1.absLocal();
        this.col2.absLocal();
    }

    public static final Mat22 abs(Mat22 mat22) {
        return mat22.abs();
    }

    public static void absToOut(Mat22 mat22, Mat22 mat222) {
        mat222.col1.x = MathUtils.abs(mat22.col1.x);
        mat222.col1.y = MathUtils.abs(mat22.col1.y);
        mat222.col2.x = MathUtils.abs(mat22.col2.x);
        mat222.col2.y = MathUtils.abs(mat22.col2.y);
    }

    public final Vec2 mul(Vec2 vec2) {
        return new Vec2(this.col1.x * vec2.x + this.col2.x * vec2.y, this.col1.y * vec2.x + this.col2.y * vec2.y);
    }

    public final void mulToOut(Vec2 vec2, Vec2 vec22) {
        float f = this.col1.y * vec2.x + this.col2.y * vec2.y;
        vec22.x = this.col1.x * vec2.x + this.col2.x * vec2.y;
        vec22.y = f;
    }

    public final Mat22 mul(Mat22 mat22) {
        Mat22 mat222 = new Mat22();
        mat222.col1.x = this.col1.x * mat22.col1.x + this.col2.x * mat22.col1.y;
        mat222.col1.y = this.col1.y * mat22.col1.x + this.col2.y * mat22.col1.y;
        mat222.col2.x = this.col1.x * mat22.col2.x + this.col2.x * mat22.col2.y;
        mat222.col2.y = this.col1.y * mat22.col2.x + this.col2.y * mat22.col2.y;
        return mat222;
    }

    public final Mat22 mulLocal(Mat22 mat22) {
        this.mulToOut(mat22, this);
        return this;
    }

    public final void mulToOut(Mat22 mat22, Mat22 mat222) {
        float f;
        float f2;
        float f3 = this.col1.y * mat22.col1.x + this.col2.y * mat22.col1.y;
        mat222.col1.x = f2 = this.col1.x * mat22.col1.x + this.col2.x * mat22.col1.y;
        mat222.col1.y = f3;
        float f4 = this.col1.y * mat22.col2.x + this.col2.y * mat22.col2.y;
        mat222.col2.x = f = this.col1.x * mat22.col2.x + this.col2.x * mat22.col2.y;
        mat222.col2.y = f4;
    }

    public final Mat22 mulTrans(Mat22 mat22) {
        Mat22 mat222 = new Mat22();
        mat222.col1.x = Vec2.dot(this.col1, mat22.col1);
        mat222.col1.y = Vec2.dot(this.col2, mat22.col1);
        mat222.col2.x = Vec2.dot(this.col1, mat22.col2);
        mat222.col2.y = Vec2.dot(this.col2, mat22.col2);
        return mat222;
    }

    public final Mat22 mulTransLocal(Mat22 mat22) {
        this.mulTransToOut(mat22, this);
        return this;
    }

    public final void mulTransToOut(Mat22 mat22, Mat22 mat222) {
        float f = this.col1.x * mat22.col1.x + this.col1.y * mat22.col1.y;
        float f2 = this.col2.x * mat22.col1.x + this.col2.y * mat22.col1.y;
        float f3 = this.col1.x * mat22.col2.x + this.col1.y * mat22.col2.y;
        float f4 = this.col2.x * mat22.col2.x + this.col2.y * mat22.col2.y;
        mat222.col1.x = f;
        mat222.col2.x = f3;
        mat222.col1.y = f2;
        mat222.col2.y = f4;
    }

    public final Vec2 mulTrans(Vec2 vec2) {
        return new Vec2(vec2.x * this.col1.x + vec2.y * this.col1.y, vec2.x * this.col2.x + vec2.y * this.col2.y);
    }

    public final void mulTransToOut(Vec2 vec2, Vec2 vec22) {
        vec22.x = vec2.x * this.col1.x + vec2.y * this.col1.y;
        vec22.y = vec2.x * this.col2.x + vec2.y * this.col2.y;
    }

    public final Mat22 add(Mat22 mat22) {
        Mat22 mat222 = new Mat22();
        mat222.col1.x = this.col1.x + mat22.col1.x;
        mat222.col1.y = this.col1.y + mat22.col1.y;
        mat222.col2.x = this.col2.x + mat22.col2.x;
        mat222.col2.y = this.col2.y + mat22.col2.y;
        return mat222;
    }

    public final Mat22 addLocal(Mat22 mat22) {
        this.col1.x += mat22.col1.x;
        this.col1.y += mat22.col1.y;
        this.col2.x += mat22.col2.x;
        this.col2.y += mat22.col2.y;
        return this;
    }

    public final Vec2 solve(Vec2 vec2) {
        float f = this.col1.x;
        float f2 = this.col2.y;
        float f3 = this.col2.x;
        float f4 = this.col1.y;
        float f5 = f * f2 - f3 * f4;
        if (f5 != 0.0f) {
            f5 = 1.0f / f5;
        }
        Vec2 vec22 = new Vec2(f5 * (f2 * vec2.x - f3 * vec2.y), f5 * (f * vec2.y - f4 * vec2.x));
        return vec22;
    }

    public final void solveToOut(Vec2 vec2, Vec2 vec22) {
        float f = this.col1.x;
        float f2 = this.col2.y;
        float f3 = this.col2.x;
        float f4 = this.col1.y;
        float f5 = f * f2 - f3 * f4;
        if (f5 != 0.0f) {
            f5 = 1.0f / f5;
        }
        float f6 = f5 * (f * vec2.y - f4 * vec2.x);
        vec22.x = f5 * (f2 * vec2.x - f3 * vec2.y);
        vec22.y = f6;
    }

    public static final Vec2 mul(Mat22 mat22, Vec2 vec2) {
        return new Vec2(mat22.col1.x * vec2.x + mat22.col2.x * vec2.y, mat22.col1.y * vec2.x + mat22.col2.y * vec2.y);
    }

    public static final void mulToOut(Mat22 mat22, Vec2 vec2, Vec2 vec22) {
        float f = mat22.col1.y * vec2.x + mat22.col2.y * vec2.y;
        vec22.x = mat22.col1.x * vec2.x + mat22.col2.x * vec2.y;
        vec22.y = f;
    }

    public static final Mat22 mul(Mat22 mat22, Mat22 mat222) {
        Mat22 mat223 = new Mat22();
        mat223.col1.x = mat22.col1.x * mat222.col1.x + mat22.col2.x * mat222.col1.y;
        mat223.col1.y = mat22.col1.y * mat222.col1.x + mat22.col2.y * mat222.col1.y;
        mat223.col2.x = mat22.col1.x * mat222.col2.x + mat22.col2.x * mat222.col2.y;
        mat223.col2.y = mat22.col1.y * mat222.col2.x + mat22.col2.y * mat222.col2.y;
        return mat223;
    }

    public static final void mulToOut(Mat22 mat22, Mat22 mat222, Mat22 mat223) {
        float f = mat22.col1.y * mat222.col1.x + mat22.col2.y * mat222.col1.y;
        float f2 = mat22.col1.x * mat222.col1.x + mat22.col2.x * mat222.col1.y;
        float f3 = mat22.col1.y * mat222.col2.x + mat22.col2.y * mat222.col2.y;
        float f4 = mat22.col1.x * mat222.col2.x + mat22.col2.x * mat222.col2.y;
        mat223.col1.x = f2;
        mat223.col1.y = f;
        mat223.col2.x = f4;
        mat223.col2.y = f3;
    }

    public static final Vec2 mulTrans(Mat22 mat22, Vec2 vec2) {
        return new Vec2(vec2.x * mat22.col1.x + vec2.y * mat22.col1.y, vec2.x * mat22.col2.x + vec2.y * mat22.col2.y);
    }

    public static final void mulTransToOut(Mat22 mat22, Vec2 vec2, Vec2 vec22) {
        float f = vec2.x * mat22.col1.x + vec2.y * mat22.col1.y;
        vec22.y = vec2.x * mat22.col2.x + vec2.y * mat22.col2.y;
        vec22.x = f;
    }

    public static final Mat22 mulTrans(Mat22 mat22, Mat22 mat222) {
        Mat22 mat223 = new Mat22();
        mat223.col1.x = mat22.col1.x * mat222.col1.x + mat22.col1.y * mat222.col1.y;
        mat223.col1.y = mat22.col2.x * mat222.col1.x + mat22.col2.y * mat222.col1.y;
        mat223.col2.x = mat22.col1.x * mat222.col2.x + mat22.col1.y * mat222.col2.y;
        mat223.col2.y = mat22.col2.x * mat222.col2.x + mat22.col2.y * mat222.col2.y;
        return mat223;
    }

    public static final void mulTransToOut(Mat22 mat22, Mat22 mat222, Mat22 mat223) {
        float f = mat22.col1.x * mat222.col1.x + mat22.col1.y * mat222.col1.y;
        float f2 = mat22.col2.x * mat222.col1.x + mat22.col2.y * mat222.col1.y;
        float f3 = mat22.col1.x * mat222.col2.x + mat22.col1.y * mat222.col2.y;
        float f4 = mat22.col2.x * mat222.col2.x + mat22.col2.y * mat222.col2.y;
        mat223.col1.x = f;
        mat223.col1.y = f2;
        mat223.col2.x = f3;
        mat223.col2.y = f4;
    }

    public static final Mat22 createRotationalTransform(float f) {
        Mat22 mat22 = new Mat22();
        float f2 = MathUtils.cos(f);
        float f3 = MathUtils.sin(f);
        mat22.col1.x = f2;
        mat22.col2.x = -f3;
        mat22.col1.y = f3;
        mat22.col2.y = f2;
        return mat22;
    }

    public static final void createRotationalTransform(float f, Mat22 mat22) {
        float f2 = MathUtils.cos(f);
        float f3 = MathUtils.sin(f);
        mat22.col1.x = f2;
        mat22.col2.x = -f3;
        mat22.col1.y = f3;
        mat22.col2.y = f2;
    }

    public static final Mat22 createScaleTransform(float f) {
        Mat22 mat22 = new Mat22();
        mat22.col1.x = f;
        mat22.col2.y = f;
        return mat22;
    }

    public static final void createScaleTransform(float f, Mat22 mat22) {
        mat22.col1.x = f;
        mat22.col2.y = f;
    }
}

