/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.common;

import java.util.Random;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;

public class MathUtils {
    public static final float PI = (float)Math.PI;
    public static final float TWOPI = (float)Math.PI * 2;
    public static final float INV_PI = 0.31830987f;
    public static final float HALF_PI = 1.5707964f;
    public static final float QUARTER_PI = 0.7853982f;
    public static final float THREE_HALVES_PI = 4.712389f;
    public static final float DEG2RAD = (float)Math.PI / 180;
    public static final float RAD2DEG = 57.295776f;
    private static final float SHIFT23 = 8388608.0f;
    private static final float INV_SHIFT23 = 1.1920929E-7f;
    public static final float[] sinLUT = new float[Settings.SINCOS_LUT_LENGTH];
    public static final float[] cosLUT = new float[Settings.SINCOS_LUT_LENGTH];

    public static final float sin(float f) {
        return (float)StrictMath.sin(f);
    }

    public static final float sinLUT(float f) {
        f %= (float)Math.PI * 2;
        while (f < 0.0f) {
            f += (float)Math.PI * 2;
        }
        return sinLUT[MathUtils.round(f / 1.1E-4f) % Settings.SINCOS_LUT_LENGTH];
    }

    public static final float cos(float f) {
        return (float)StrictMath.cos(f);
    }

    public static final float abs(float f) {
        return f > 0.0f ? f : -f;
    }

    public static final int abs(int n) {
        int n2 = n >> 31;
        return (n ^ n2) - n2;
    }

    public static final int floor(float f) {
        int n = (int)f;
        if (f < 0.0f && f != (float)n) {
            --n;
        }
        return n;
    }

    public static final int ceil(float f) {
        int n = (int)f;
        if (f > 0.0f && f != (float)n) {
            ++n;
        }
        return n;
    }

    public static final int round(float f) {
        return MathUtils.floor(f + 0.5f);
    }

    public static final int ceilPowerOf2(int n) {
        int n2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        return n2;
    }

    public static final float max(float f, float f2) {
        return f > f2 ? f : f2;
    }

    public static final int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    public static final float min(float f, float f2) {
        return f < f2 ? f : f2;
    }

    public static final float map(float f, float f2, float f3, float f4, float f5) {
        float f6 = (f - f2) / (f3 - f2);
        float f7 = f4 + f6 * (f5 - f4);
        return f7;
    }

    public static final float clamp(float f, float f2, float f3) {
        return MathUtils.max(f2, MathUtils.min(f, f3));
    }

    public static final Vec2 clamp(Vec2 vec2, Vec2 vec22, Vec2 vec23) {
        Vec2 vec24 = new Vec2();
        vec24.x = vec2.x < vec23.x ? vec2.x : vec23.x;
        vec24.y = vec2.y < vec23.y ? vec2.y : vec23.y;
        vec24.x = vec22.x > vec24.x ? vec22.x : vec24.x;
        vec24.y = vec22.y > vec24.y ? vec22.y : vec24.y;
        return vec24;
    }

    public static final void clampToOut(Vec2 vec2, Vec2 vec22, Vec2 vec23, Vec2 vec24) {
        vec24.x = vec2.x < vec23.x ? vec2.x : vec23.x;
        vec24.y = vec2.y < vec23.y ? vec2.y : vec23.y;
        vec24.x = vec22.x > vec24.x ? vec22.x : vec24.x;
        vec24.y = vec22.y > vec24.y ? vec22.y : vec24.y;
    }

    public static final int nextPowerOfTwo(int n) {
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        n |= n >> 16;
        return n + 1;
    }

    public static final boolean isPowerOfTwo(int n) {
        return n > 0 && (n & n - 1) == 0;
    }

    public static final float fastPow(float f, float f2) {
        float f3 = Float.floatToRawIntBits(f);
        f3 *= 1.1920929E-7f;
        float f4 = f3 - (float)((f3 -= 127.0f) >= 0.0f ? (int)f3 : (int)f3 - 1);
        f4 = f2 - (float)(f2 >= 0.0f ? (int)f2 : (int)(f2 *= f3 + (f4 - f4 * f4) * 0.346607f) - 1);
        f4 = (f4 - f4 * f4) * 0.33971f;
        return Float.intBitsToFloat((int)((f2 + 127.0f - f4) * 8388608.0f));
    }

    public static final float atan2(float f, float f2) {
        return MathUtils.fastAtan2(f, f2);
    }

    public static final float fastAtan2(float f, float f2) {
        float f3;
        if (f2 == 0.0f) {
            if (f > 0.0f) {
                return 1.5707964f;
            }
            if (f == 0.0f) {
                return 0.0f;
            }
            return -1.5707964f;
        }
        float f4 = f / f2;
        if (MathUtils.abs(f4) < 1.0f) {
            f3 = f4 / (1.0f + 0.28f * f4 * f4);
            if (f2 < 0.0f) {
                if (f < 0.0f) {
                    return f3 - (float)Math.PI;
                }
                return f3 + (float)Math.PI;
            }
        } else {
            f3 = 1.5707964f - f4 / (f4 * f4 + 0.28f);
            if (f < 0.0f) {
                return f3 - (float)Math.PI;
            }
        }
        return f3;
    }

    public static final float reduceAngle(float f) {
        if (MathUtils.abs(f %= (float)Math.PI * 2) > (float)Math.PI) {
            f -= (float)Math.PI * 2;
        }
        if (MathUtils.abs(f) > 1.5707964f) {
            f = (float)Math.PI - f;
        }
        return f;
    }

    public static final float pow(float f, float f2) {
        float f3 = Float.floatToRawIntBits(f);
        f3 *= 1.1920929E-7f;
        float f4 = (f3 -= 127.0f) - (float)MathUtils.floor(f3);
        f2 *= f3 + (f4 - f4 * f4) * 0.346607f;
        f4 = f2 - (float)MathUtils.floor(f2);
        f4 = (f4 - f4 * f4) * 0.33971f;
        return Float.intBitsToFloat((int)((f2 + 127.0f - f4) * 8388608.0f));
    }

    public static final float randomFloat(float f, float f2) {
        return (float)Math.random() * (f2 - f) + f;
    }

    public static final float randomFloat(Random random, float f, float f2) {
        return random.nextFloat() * (f2 - f) + f;
    }

    public static final float sqrt(float f) {
        return (float)StrictMath.sqrt(f);
    }

    public static final float distanceSquared(Vec2 vec2, Vec2 vec22) {
        float f = vec2.x - vec22.x;
        float f2 = vec2.y - vec22.y;
        return f * f + f2 * f2;
    }

    public static final float distance(Vec2 vec2, Vec2 vec22) {
        return MathUtils.sqrt(MathUtils.distanceSquared(vec2, vec22));
    }

    static {
        for (int i = 0; i < Settings.SINCOS_LUT_LENGTH; ++i) {
            MathUtils.sinLUT[i] = (float)Math.sin((float)i * 1.1E-4f);
            MathUtils.cosLUT[i] = (float)Math.cos((float)i * 1.1E-4f);
        }
    }
}

