/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics;

import org.jbox2d.callbacks.ContactImpulse;
import org.jbox2d.callbacks.ContactListener;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.Position;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.Velocity;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactConstraint;
import org.jbox2d.dynamics.contacts.ContactSolver;
import org.jbox2d.dynamics.joints.Joint;

public class Island {
    public ContactListener m_listener;
    public Body[] m_bodies;
    public Contact[] m_contacts;
    public Joint[] m_joints;
    public Position[] m_positions;
    public Velocity[] m_velocities;
    public int m_bodyCount;
    public int m_jointCount;
    public int m_contactCount;
    public int m_bodyCapacity;
    public int m_contactCapacity;
    public int m_jointCapacity;
    public int m_positionIterationCount;
    private final Vec2 temp = new Vec2();
    private final ContactSolver contactSolver = new ContactSolver();
    private final Vec2 translation = new Vec2();
    private final ContactImpulse impulse = new ContactImpulse();

    public void init(int n, int n2, int n3, ContactListener contactListener) {
        int n4;
        this.m_bodyCapacity = n;
        this.m_contactCapacity = n2;
        this.m_jointCapacity = n3;
        this.m_bodyCount = 0;
        this.m_contactCount = 0;
        this.m_jointCount = 0;
        this.m_listener = contactListener;
        if (this.m_bodies == null || this.m_bodyCapacity > this.m_bodies.length) {
            this.m_bodies = new Body[this.m_bodyCapacity];
        }
        if (this.m_joints == null || this.m_jointCapacity > this.m_joints.length) {
            this.m_joints = new Joint[this.m_jointCapacity];
        }
        if (this.m_contacts == null || this.m_contactCapacity > this.m_contacts.length) {
            this.m_contacts = new Contact[this.m_contactCapacity];
        }
        if (this.m_velocities == null || this.m_bodyCapacity > this.m_velocities.length) {
            this.m_velocities = new Velocity[this.m_bodyCapacity];
            for (n4 = 0; n4 < this.m_velocities.length; ++n4) {
                this.m_velocities[n4] = new Velocity();
            }
        }
        if (this.m_positions == null || this.m_bodyCapacity > this.m_positions.length) {
            this.m_positions = new Position[this.m_bodyCapacity];
            for (n4 = 0; n4 < this.m_positions.length; ++n4) {
                this.m_positions[n4] = new Position();
            }
        }
    }

    public void clear() {
        this.m_bodyCount = 0;
        this.m_contactCount = 0;
        this.m_jointCount = 0;
    }

    public void solve(TimeStep timeStep, Vec2 vec2, boolean bl) {
        int n;
        int n2;
        for (n2 = 0; n2 < this.m_bodyCount; ++n2) {
            Body body = this.m_bodies[n2];
            if (body.getType() != BodyType.DYNAMIC) continue;
            body.m_linearVelocity.x += (body.m_force.x * body.m_invMass + vec2.x) * timeStep.dt;
            body.m_linearVelocity.y += (body.m_force.y * body.m_invMass + vec2.y) * timeStep.dt;
            body.m_angularVelocity += timeStep.dt * body.m_invI * body.m_torque;
            float f = 1.0f - timeStep.dt * body.m_linearDamping;
            float f2 = 0.0f > (f < 1.0f ? f : 1.0f) ? 0.0f : (f < 1.0f ? f : 1.0f);
            body.m_linearVelocity.x *= f2;
            body.m_linearVelocity.y *= f2;
            float f3 = 1.0f - timeStep.dt * body.m_angularDamping;
            float f4 = f3 < 1.0f ? f3 : 1.0f;
            body.m_angularVelocity = body.m_angularVelocity * (0.0f > f4 ? 0.0f : f4);
        }
        n2 = -1;
        for (n = 0; n < this.m_contactCount; ++n) {
            boolean bl2;
            Fixture fixture = this.m_contacts[n].getFixtureA();
            Fixture fixture2 = this.m_contacts[n].getFixtureB();
            Body body = fixture.getBody();
            Body body2 = fixture2.getBody();
            boolean bl3 = bl2 = body.getType() != BodyType.STATIC && body2.getType() != BodyType.STATIC;
            if (!bl2) continue;
            Contact contact = this.m_contacts[++n2];
            this.m_contacts[n2] = this.m_contacts[n];
            this.m_contacts[n] = contact;
        }
        this.contactSolver.init(this.m_contacts, this.m_contactCount, timeStep.dtRatio);
        this.contactSolver.warmStart();
        for (n = 0; n < this.m_jointCount; ++n) {
            this.m_joints[n].initVelocityConstraints(timeStep);
        }
        for (n = 0; n < timeStep.velocityIterations; ++n) {
            for (int i = 0; i < this.m_jointCount; ++i) {
                this.m_joints[i].solveVelocityConstraints(timeStep);
            }
            this.contactSolver.solveVelocityConstraints();
        }
        this.contactSolver.storeImpulses();
        for (n = 0; n < this.m_bodyCount; ++n) {
            float f;
            Body body = this.m_bodies[n];
            if (body.getType() == BodyType.STATIC) continue;
            this.translation.set(body.m_linearVelocity).mulLocal(timeStep.dt);
            if (Vec2.dot(this.translation, this.translation) > Settings.maxTranslationSquared) {
                f = Settings.maxTranslation / this.translation.length();
                body.m_linearVelocity.mulLocal(f);
            }
            if ((f = timeStep.dt * body.m_angularVelocity) * f > Settings.maxRotationSquared) {
                float f5 = Settings.maxRotation / Math.abs(f);
                body.m_angularVelocity *= f5;
            }
            body.m_sweep.c0.set(body.m_sweep.c);
            body.m_sweep.a0 = body.m_sweep.a;
            this.temp.set(body.m_linearVelocity).mulLocal(timeStep.dt);
            body.m_sweep.c.addLocal(this.temp);
            body.m_sweep.a += timeStep.dt * body.m_angularVelocity;
            body.synchronizeTransform();
        }
        for (n = 0; n < timeStep.positionIterations; ++n) {
            boolean bl4 = this.contactSolver.solvePositionConstraints(Settings.contactBaumgarte);
            boolean bl5 = true;
            for (int i = 0; i < this.m_jointCount; ++i) {
                boolean bl6 = this.m_joints[i].solvePositionConstraints(Settings.contactBaumgarte);
                bl5 = bl5 && bl6;
            }
            if (bl4 && bl5) break;
        }
        this.report(this.contactSolver.m_constraints);
        if (bl) {
            int n3;
            float f = Float.MAX_VALUE;
            float f6 = Settings.linearSleepTolerance * Settings.linearSleepTolerance;
            float f7 = Settings.angularSleepTolerance * Settings.angularSleepTolerance;
            for (n3 = 0; n3 < this.m_bodyCount; ++n3) {
                Body body = this.m_bodies[n3];
                if (body.getType() == BodyType.STATIC) continue;
                if ((body.m_flags & 4) == 0) {
                    body.m_sleepTime = 0.0f;
                    f = 0.0f;
                }
                if ((body.m_flags & 4) == 0 || body.m_angularVelocity * body.m_angularVelocity > f7 || Vec2.dot(body.m_linearVelocity, body.m_linearVelocity) > f6) {
                    body.m_sleepTime = 0.0f;
                    f = 0.0f;
                    continue;
                }
                body.m_sleepTime += timeStep.dt;
                f = MathUtils.min(f, body.m_sleepTime);
            }
            if (f >= Settings.timeToSleep) {
                for (n3 = 0; n3 < this.m_bodyCount; ++n3) {
                    Body body = this.m_bodies[n3];
                    body.setAwake(false);
                }
            }
        }
    }

    public void add(Body body) {
        assert (this.m_bodyCount < this.m_bodyCapacity);
        body.m_islandIndex = this.m_bodyCount;
        this.m_bodies[this.m_bodyCount++] = body;
    }

    public void add(Contact contact) {
        assert (this.m_contactCount < this.m_contactCapacity);
        this.m_contacts[this.m_contactCount++] = contact;
    }

    public void add(Joint joint) {
        assert (this.m_jointCount < this.m_jointCapacity);
        this.m_joints[this.m_jointCount++] = joint;
    }

    public void report(ContactConstraint[] contactConstraintArray) {
        if (this.m_listener == null) {
            return;
        }
        for (int i = 0; i < this.m_contactCount; ++i) {
            Contact contact = this.m_contacts[i];
            ContactConstraint contactConstraint = contactConstraintArray[i];
            for (int j = 0; j < contactConstraint.pointCount; ++j) {
                this.impulse.normalImpulses[j] = contactConstraint.points[j].normalImpulse;
                this.impulse.tangentImpulses[j] = contactConstraint.points[j].tangentImpulse;
            }
            this.m_listener.postSolve(contact, this.impulse);
        }
    }
}

