/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.contacts;

import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.TOIConstraint;
import org.jbox2d.dynamics.contacts.TOISolverManifold;

public class TOISolver {
    private TOIConstraint[] m_constraints = new TOIConstraint[4];
    private int m_count = 0;
    private Body m_toiBody = null;
    private final TOISolverManifold psm = new TOISolverManifold();
    private final Vec2 rA = new Vec2();
    private final Vec2 rB = new Vec2();
    private final Vec2 P = new Vec2();
    private final Vec2 temp = new Vec2();

    public TOISolver() {
        for (int i = 0; i < this.m_constraints.length; ++i) {
            this.m_constraints[i] = new TOIConstraint();
        }
    }

    public void clear() {
    }

    public void initialize(Contact[] contactArray, int n, Body body) {
        this.m_count = n;
        this.m_toiBody = body;
        if (this.m_count >= this.m_constraints.length) {
            TOIConstraint[] tOIConstraintArray = this.m_constraints;
            this.m_constraints = new TOIConstraint[tOIConstraintArray.length * 2];
            System.arraycopy(tOIConstraintArray, 0, this.m_constraints, 0, tOIConstraintArray.length);
            for (int i = tOIConstraintArray.length; i < this.m_constraints.length; ++i) {
                this.m_constraints[i] = new TOIConstraint();
            }
        }
        for (int i = 0; i < this.m_count; ++i) {
            Contact contact = contactArray[i];
            Fixture fixture = contact.getFixtureA();
            Fixture fixture2 = contact.getFixtureB();
            Shape shape = fixture.getShape();
            Shape shape2 = fixture2.getShape();
            float f = shape.m_radius;
            float f2 = shape2.m_radius;
            Body body2 = fixture.getBody();
            Body body3 = fixture2.getBody();
            Manifold manifold = contact.getManifold();
            assert (manifold.pointCount > 0);
            TOIConstraint tOIConstraint = this.m_constraints[i];
            tOIConstraint.bodyA = body2;
            tOIConstraint.bodyB = body3;
            tOIConstraint.localNormal.set(manifold.localNormal);
            tOIConstraint.localPoint.set(manifold.localPoint);
            tOIConstraint.type = manifold.type;
            tOIConstraint.pointCount = manifold.pointCount;
            tOIConstraint.radius = f + f2;
            for (int j = 0; j < tOIConstraint.pointCount; ++j) {
                ManifoldPoint manifoldPoint = manifold.points[j];
                tOIConstraint.localPoints[j] = manifoldPoint.localPoint;
            }
        }
    }

    public boolean solve(float f) {
        float f2 = 0.0f;
        for (int i = 0; i < this.m_count; ++i) {
            TOIConstraint tOIConstraint = this.m_constraints[i];
            Body body = tOIConstraint.bodyA;
            Body body2 = tOIConstraint.bodyB;
            float f3 = body.m_mass;
            float f4 = body2.m_mass;
            if (body == this.m_toiBody) {
                f4 = 0.0f;
            } else {
                f3 = 0.0f;
            }
            float f5 = f3 * body.m_invMass;
            float f6 = f3 * body.m_invI;
            float f7 = f4 * body2.m_invMass;
            float f8 = f4 * body2.m_invI;
            for (int j = 0; j < tOIConstraint.pointCount; ++j) {
                this.psm.initialize(tOIConstraint, j);
                Vec2 vec2 = this.psm.normal;
                Vec2 vec22 = this.psm.point;
                float f9 = this.psm.separation;
                this.rA.set(vec22).subLocal(body.m_sweep.c);
                this.rB.set(vec22).subLocal(body2.m_sweep.c);
                f2 = MathUtils.min(f2, f9);
                float f10 = MathUtils.clamp(f * (f9 + Settings.linearSlop), -Settings.maxLinearCorrection, 0.0f);
                float f11 = Vec2.cross(this.rA, vec2);
                float f12 = Vec2.cross(this.rB, vec2);
                float f13 = f5 + f7 + f6 * f11 * f11 + f8 * f12 * f12;
                float f14 = f13 > 0.0f ? -f10 / f13 : 0.0f;
                this.P.set(vec2).mulLocal(f14);
                this.temp.set(this.P).mulLocal(f5);
                body.m_sweep.c.subLocal(this.temp);
                body.m_sweep.a -= f6 * Vec2.cross(this.rA, this.P);
                body.synchronizeTransform();
                this.temp.set(this.P).mulLocal(f7);
                body2.m_sweep.c.addLocal(this.temp);
                body2.m_sweep.a += f8 * Vec2.cross(this.rB, this.P);
                body2.synchronizeTransform();
            }
        }
        return f2 >= -1.5f * Settings.linearSlop;
    }
}

