/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.contacts;

import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.contacts.TOIConstraint;

class TOISolverManifold {
    public final Vec2 normal = new Vec2();
    public final Vec2 point = new Vec2();
    public float separation;
    private final Vec2 pointA = new Vec2();
    private final Vec2 pointB = new Vec2();
    private final Vec2 temp = new Vec2();
    private final Vec2 planePoint = new Vec2();
    private final Vec2 clipPoint = new Vec2();

    TOISolverManifold() {
    }

    public void initialize(TOIConstraint tOIConstraint, int n) {
        assert (tOIConstraint.pointCount > 0);
        switch (tOIConstraint.type) {
            case CIRCLES: {
                tOIConstraint.bodyA.getWorldPointToOut(tOIConstraint.localPoint, this.pointA);
                tOIConstraint.bodyB.getWorldPointToOut(tOIConstraint.localPoints[0], this.pointB);
                if (MathUtils.distanceSquared(this.pointA, this.pointB) > 1.4210855E-14f) {
                    this.normal.set(this.pointB).subLocal(this.pointA);
                    this.normal.normalize();
                } else {
                    this.normal.set(1.0f, 0.0f);
                }
                this.point.set(this.pointA).addLocal(this.pointB).mulLocal(0.5f);
                this.temp.set(this.pointB).subLocal(this.pointA);
                this.separation = Vec2.dot(this.temp, this.normal) - tOIConstraint.radius;
                break;
            }
            case FACE_A: {
                tOIConstraint.bodyA.getWorldVectorToOut(tOIConstraint.localNormal, this.normal);
                tOIConstraint.bodyA.getWorldPointToOut(tOIConstraint.localPoint, this.planePoint);
                tOIConstraint.bodyB.getWorldPointToOut(tOIConstraint.localPoints[n], this.clipPoint);
                this.temp.set(this.clipPoint).subLocal(this.planePoint);
                this.separation = Vec2.dot(this.temp, this.normal) - tOIConstraint.radius;
                this.point.set(this.clipPoint);
                break;
            }
            case FACE_B: {
                tOIConstraint.bodyB.getWorldVectorToOut(tOIConstraint.localNormal, this.normal);
                tOIConstraint.bodyB.getWorldPointToOut(tOIConstraint.localPoint, this.planePoint);
                tOIConstraint.bodyA.getWorldPointToOut(tOIConstraint.localPoints[n], this.clipPoint);
                this.temp.set(this.clipPoint).subLocal(this.planePoint);
                this.separation = Vec2.dot(this.temp, this.normal) - tOIConstraint.radius;
                this.point.set(this.clipPoint);
                this.normal.negateLocal();
            }
        }
    }
}

