/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.joints.FrictionJointDef;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.pooling.IWorldPool;

public class FrictionJoint
extends Joint {
    private final Vec2 m_localAnchorA;
    private final Vec2 m_localAnchorB;
    private final Mat22 m_linearMass;
    private float m_angularMass;
    private final Vec2 m_linearImpulse;
    private float m_angularImpulse;
    private float m_maxForce;
    private float m_maxTorque;

    public FrictionJoint(IWorldPool iWorldPool, FrictionJointDef frictionJointDef) {
        super(iWorldPool, frictionJointDef);
        this.m_localAnchorA = new Vec2(frictionJointDef.localAnchorA);
        this.m_localAnchorB = new Vec2(frictionJointDef.localAnchorB);
        this.m_linearImpulse = new Vec2();
        this.m_angularImpulse = 0.0f;
        this.m_maxForce = frictionJointDef.maxForce;
        this.m_maxTorque = frictionJointDef.maxTorque;
        this.m_linearMass = new Mat22();
    }

    public void getAnchorA(Vec2 vec2) {
        this.m_bodyA.getWorldPointToOut(this.m_localAnchorA, vec2);
    }

    public void getAnchorB(Vec2 vec2) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchorB, vec2);
    }

    public void getReactionForce(float f, Vec2 vec2) {
        vec2.set(this.m_linearImpulse).mulLocal(f);
    }

    public float getReactionTorque(float f) {
        return f * this.m_angularImpulse;
    }

    public void setMaxForce(float f) {
        assert (f >= 0.0f);
        this.m_maxForce = f;
    }

    public float getMaxForce() {
        return this.m_maxForce;
    }

    public void setMaxTorque(float f) {
        assert (f >= 0.0f);
        this.m_maxTorque = f;
    }

    public float getMaxTorque() {
        return this.m_maxTorque;
    }

    public void initVelocityConstraints(TimeStep timeStep) {
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        Vec2 vec2 = this.pool.popVec2();
        Vec2 vec22 = this.pool.popVec2();
        vec2.set(this.m_localAnchorA).subLocal(body.getLocalCenter());
        vec22.set(this.m_localAnchorB).subLocal(body2.getLocalCenter());
        Mat22.mulToOut(body.getTransform().R, vec2, vec2);
        Mat22.mulToOut(body2.getTransform().R, vec22, vec22);
        float f = body.m_invMass;
        float f2 = body2.m_invMass;
        float f3 = body.m_invI;
        float f4 = body2.m_invI;
        Mat22 mat22 = this.pool.popMat22();
        mat22.col1.x = f + f2;
        mat22.col2.x = 0.0f;
        mat22.col1.y = 0.0f;
        mat22.col2.y = f + f2;
        Mat22 mat222 = this.pool.popMat22();
        mat222.col1.x = f3 * vec2.y * vec2.y;
        mat222.col2.x = -f3 * vec2.x * vec2.y;
        mat222.col1.y = -f3 * vec2.x * vec2.y;
        mat222.col2.y = f3 * vec2.x * vec2.x;
        Mat22 mat223 = this.pool.popMat22();
        mat223.col1.x = f4 * vec22.y * vec22.y;
        mat223.col2.x = -f4 * vec22.x * vec22.y;
        mat223.col1.y = -f4 * vec22.x * vec22.y;
        mat223.col2.y = f4 * vec22.x * vec22.x;
        mat22.addLocal(mat222).addLocal(mat223);
        this.m_linearMass.set(mat22).invertLocal();
        this.m_angularMass = f3 + f4;
        if (this.m_angularMass > 0.0f) {
            this.m_angularMass = 1.0f / this.m_angularMass;
        }
        if (timeStep.warmStarting) {
            this.m_linearImpulse.mulLocal(timeStep.dtRatio);
            this.m_angularImpulse *= timeStep.dtRatio;
            Vec2 vec23 = this.pool.popVec2();
            vec23.set(this.m_linearImpulse.x, this.m_linearImpulse.y);
            Vec2 vec24 = this.pool.popVec2();
            vec24.set(vec23).mulLocal(f);
            body.m_linearVelocity.subLocal(vec24);
            body.m_angularVelocity -= f3 * (Vec2.cross(vec2, vec23) + this.m_angularImpulse);
            vec24.set(vec23).mulLocal(f2);
            body2.m_linearVelocity.addLocal(vec24);
            body2.m_angularVelocity += f4 * (Vec2.cross(vec22, vec23) + this.m_angularImpulse);
            this.pool.pushVec2(2);
        } else {
            this.m_linearImpulse.setZero();
            this.m_angularImpulse = 0.0f;
        }
        this.pool.pushVec2(2);
        this.pool.pushMat22(3);
    }

    public void solveVelocityConstraints(TimeStep timeStep) {
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        Vec2 vec2 = body.m_linearVelocity;
        float f = body.m_angularVelocity;
        Vec2 vec22 = body2.m_linearVelocity;
        float f2 = body2.m_angularVelocity;
        float f3 = body.m_invMass;
        float f4 = body2.m_invMass;
        float f5 = body.m_invI;
        float f6 = body2.m_invI;
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        vec23.set(this.m_localAnchorA).subLocal(body.getLocalCenter());
        vec24.set(this.m_localAnchorB).subLocal(body2.getLocalCenter());
        Mat22.mulToOut(body.getTransform().R, vec23, vec23);
        Mat22.mulToOut(body2.getTransform().R, vec24, vec24);
        float f7 = f2 - f;
        float f8 = -this.m_angularMass * f7;
        float f9 = this.m_angularImpulse;
        float f10 = timeStep.dt * this.m_maxTorque;
        this.m_angularImpulse = MathUtils.clamp(this.m_angularImpulse + f8, -f10, f10);
        f8 = this.m_angularImpulse - f9;
        Vec2 vec25 = this.pool.popVec2();
        Vec2 vec26 = this.pool.popVec2();
        Vec2.crossToOut(f -= f5 * f8, vec23, vec26);
        Vec2.crossToOut(f2 += f6 * f8, vec24, vec25);
        vec25.addLocal(vec22).subLocal(vec2).subLocal(vec26);
        Vec2 vec27 = this.pool.popVec2();
        Mat22.mulToOut(this.m_linearMass, vec25, vec27);
        vec27.negateLocal();
        Vec2 vec28 = this.pool.popVec2();
        vec28.set(this.m_linearImpulse);
        this.m_linearImpulse.addLocal(vec27);
        float f11 = timeStep.dt * this.m_maxForce;
        if (this.m_linearImpulse.lengthSquared() > f11 * f11) {
            this.m_linearImpulse.normalize();
            this.m_linearImpulse.mulLocal(f11);
        }
        vec27.set(this.m_linearImpulse).subLocal(vec28);
        vec26.set(vec27).mulLocal(f3);
        vec2.subLocal(vec26);
        f -= f5 * Vec2.cross(vec23, vec27);
        vec26.set(vec27).mulLocal(f4);
        vec22.addLocal(vec26);
        this.pool.pushVec2(6);
        body.m_angularVelocity = f;
        body2.m_angularVelocity = f2 += f6 * Vec2.cross(vec24, vec27);
    }

    public boolean solvePositionConstraints(float f) {
        return true;
    }
}

