/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.LimitState;
import org.jbox2d.dynamics.joints.LineJointDef;
import org.jbox2d.pooling.IWorldPool;

public class LineJoint
extends Joint {
    private final Vec2 m_localAnchor1 = new Vec2();
    private final Vec2 m_localAnchor2 = new Vec2();
    private final Vec2 m_localXAxis1 = new Vec2();
    private final Vec2 m_localYAxis1 = new Vec2();
    private final Vec2 m_axis = new Vec2();
    private final Vec2 m_perp = new Vec2();
    private float m_s1;
    private float m_s2;
    private float m_a1;
    private float m_a2;
    private final Mat22 m_K = new Mat22();
    private final Vec2 m_impulse = new Vec2();
    private float m_motorMass;
    private float m_motorImpulse;
    private float m_lowerTranslation;
    private float m_upperTranslation;
    private float m_maxMotorForce;
    private float m_motorSpeed;
    private boolean m_enableLimit;
    private boolean m_enableMotor;
    private LimitState m_limitState;

    public LineJoint(IWorldPool iWorldPool, LineJointDef lineJointDef) {
        super(iWorldPool, lineJointDef);
        this.m_localAnchor1.set(lineJointDef.localAnchorA);
        this.m_localAnchor2.set(lineJointDef.localAnchorB);
        this.m_localXAxis1.set(lineJointDef.localAxisA);
        Vec2.crossToOut(1.0f, this.m_localXAxis1, this.m_localYAxis1);
        this.m_impulse.setZero();
        this.m_motorMass = 0.0f;
        this.m_motorImpulse = 0.0f;
        this.m_lowerTranslation = lineJointDef.lowerTranslation;
        this.m_upperTranslation = lineJointDef.upperTranslation;
        this.m_maxMotorForce = lineJointDef.maxMotorForce;
        this.m_motorSpeed = lineJointDef.motorSpeed;
        this.m_enableLimit = lineJointDef.enableLimit;
        this.m_enableMotor = lineJointDef.enableMotor;
        this.m_limitState = LimitState.INACTIVE;
        this.m_axis.setZero();
        this.m_perp.setZero();
    }

    public void getAnchorA(Vec2 vec2) {
        this.m_bodyA.getWorldPointToOut(this.m_localAnchor1, vec2);
    }

    public void getAnchorB(Vec2 vec2) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchor2, vec2);
    }

    public void getReactionForce(float f, Vec2 vec2) {
        Vec2 vec22 = this.pool.popVec2();
        vec22.set(this.m_perp).mulLocal(this.m_impulse.x);
        vec2.set(this.m_axis).mulLocal(this.m_motorImpulse + this.m_impulse.y).addLocal(vec22).mulLocal(f);
        this.pool.pushVec2(1);
    }

    public float getReactionTorque(float f) {
        return 0.0f;
    }

    public float getJointTranslation() {
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        Vec2 vec2 = this.pool.popVec2();
        Vec2 vec22 = this.pool.popVec2();
        Vec2 vec23 = this.pool.popVec2();
        body.getWorldPointToOut(this.m_localAnchor1, vec2);
        body2.getWorldPointToOut(this.m_localAnchor1, vec22);
        vec22.subLocal(vec2);
        body.getWorldVectorToOut(this.m_localXAxis1, vec23);
        float f = Vec2.dot(vec22, vec23);
        this.pool.pushVec2(3);
        return f;
    }

    public float getJointSpeed() {
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        Vec2 vec2 = this.pool.popVec2();
        Vec2 vec22 = this.pool.popVec2();
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        vec2.set(this.m_localAnchor1).subLocal(body.getLocalCenter());
        vec22.set(this.m_localAnchor2).subLocal(body2.getLocalCenter());
        Mat22.mulToOut(body.getTransform().R, vec2, vec2);
        Mat22.mulToOut(body2.getTransform().R, vec22, vec22);
        vec23.set(body.m_sweep.c).addLocal(vec2);
        vec24.set(body2.m_sweep.c).addLocal(vec22);
        vec24.subLocal(vec23);
        Vec2 vec25 = this.pool.popVec2();
        body.getWorldPointToOut(this.m_localXAxis1, vec25);
        Vec2 vec26 = body.m_linearVelocity;
        Vec2 vec27 = body2.m_linearVelocity;
        float f = body.m_angularVelocity;
        float f2 = body2.m_angularVelocity;
        Vec2 vec28 = this.pool.popVec2();
        Vec2 vec29 = this.pool.popVec2();
        Vec2.crossToOut(f, vec2, vec28);
        Vec2.crossToOut(f2, vec22, vec29);
        vec29.addLocal(vec27).subLocal(vec26).subLocal(vec28);
        float f3 = Vec2.dot(vec25, vec29);
        Vec2.crossToOut(f, vec25, vec28);
        float f4 = Vec2.dot(vec24, vec28) + f3;
        this.pool.pushVec2(7);
        return f4;
    }

    public boolean isLimitEnabled() {
        return this.m_enableLimit;
    }

    public void EnableLimit(boolean bl) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_enableLimit = bl;
    }

    public float getLowerLimit() {
        return this.m_lowerTranslation;
    }

    public float getUpperLimit() {
        return this.m_upperTranslation;
    }

    public void setLimits(float f, float f2) {
        assert (f <= f2);
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_lowerTranslation = f;
        this.m_upperTranslation = f2;
    }

    public boolean isMotorEnabled() {
        return this.m_enableMotor;
    }

    public void EnableMotor(boolean bl) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_enableMotor = bl;
    }

    public void setMotorSpeed(float f) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_motorSpeed = f;
    }

    public void setMaxMotorForce(float f) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_maxMotorForce = f;
    }

    public float getMotorForce() {
        return this.m_motorImpulse;
    }

    public void initVelocityConstraints(TimeStep timeStep) {
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        this.m_localCenterA.set(body.getLocalCenter());
        this.m_localCenterB.set(body2.getLocalCenter());
        Transform transform = body.getTransform();
        Transform transform2 = body2.getTransform();
        Vec2 vec2 = this.pool.popVec2();
        Vec2 vec22 = this.pool.popVec2();
        Vec2 vec23 = this.pool.popVec2();
        vec2.set(this.m_localAnchor1).subLocal(this.m_localCenterA);
        vec22.set(this.m_localAnchor2).subLocal(this.m_localCenterB);
        Mat22.mulToOut(transform.R, vec2, vec2);
        Mat22.mulToOut(transform2.R, vec22, vec22);
        Vec2 vec24 = this.pool.popVec2();
        vec24.set(body2.m_sweep.c).addLocal(vec22).subLocal(body.m_sweep.c).subLocal(vec2);
        this.m_invMassA = body.m_invMass;
        this.m_invIA = body.m_invI;
        this.m_invMassB = body2.m_invMass;
        this.m_invIB = body2.m_invI;
        Mat22.mulToOut(transform.R, this.m_localXAxis1, this.m_axis);
        vec23.set(vec24).addLocal(vec2);
        this.m_a1 = Vec2.cross(vec23, this.m_axis);
        this.m_a2 = Vec2.cross(vec22, this.m_axis);
        this.m_motorMass = this.m_invMassA + this.m_invMassB + this.m_invIA * this.m_a1 * this.m_a1 + this.m_invIB * this.m_a2 * this.m_a2;
        this.m_motorMass = this.m_motorMass > 1.1920929E-7f ? 1.0f / this.m_motorMass : 0.0f;
        Mat22.mulToOut(transform.R, this.m_localYAxis1, this.m_perp);
        vec23.set(vec24).addLocal(vec2);
        this.m_s1 = Vec2.cross(vec23, this.m_perp);
        this.m_s2 = Vec2.cross(vec22, this.m_perp);
        float f = this.m_invMassA;
        float f2 = this.m_invMassB;
        float f3 = this.m_invIA;
        float f4 = this.m_invIB;
        float f5 = f + f2 + f3 * this.m_s1 * this.m_s1 + f4 * this.m_s2 * this.m_s2;
        float f6 = f3 * this.m_s1 * this.m_a1 + f4 * this.m_s2 * this.m_a2;
        float f7 = f + f2 + f3 * this.m_a1 * this.m_a1 + f4 * this.m_a2 * this.m_a2;
        this.m_K.col1.set(f5, f6);
        this.m_K.col2.set(f6, f7);
        if (this.m_enableLimit) {
            f = Vec2.dot(this.m_axis, vec24);
            if (MathUtils.abs(this.m_upperTranslation - this.m_lowerTranslation) < 2.0f * Settings.linearSlop) {
                this.m_limitState = LimitState.EQUAL;
            } else if (f <= this.m_lowerTranslation) {
                if (this.m_limitState != LimitState.AT_LOWER) {
                    this.m_limitState = LimitState.AT_LOWER;
                    this.m_impulse.y = 0.0f;
                }
            } else if (f >= this.m_upperTranslation) {
                if (this.m_limitState != LimitState.AT_UPPER) {
                    this.m_limitState = LimitState.AT_UPPER;
                    this.m_impulse.y = 0.0f;
                }
            } else {
                this.m_limitState = LimitState.INACTIVE;
                this.m_impulse.y = 0.0f;
            }
        } else {
            this.m_limitState = LimitState.INACTIVE;
        }
        if (!this.m_enableMotor) {
            this.m_motorImpulse = 0.0f;
        }
        if (timeStep.warmStarting) {
            this.m_impulse.mulLocal(timeStep.dtRatio);
            this.m_motorImpulse *= timeStep.dtRatio;
            Vec2 vec25 = this.pool.popVec2();
            vec23.set(this.m_axis).mulLocal(this.m_motorImpulse + this.m_impulse.y);
            vec25.set(this.m_perp).mulLocal(this.m_impulse.x).addLocal(vec23);
            f2 = this.m_impulse.x * this.m_s1 + (this.m_motorImpulse + this.m_impulse.y) * this.m_a1;
            f3 = this.m_impulse.x * this.m_s2 + (this.m_motorImpulse + this.m_impulse.y) * this.m_a2;
            vec23.set(vec25).mulLocal(this.m_invMassA);
            body.m_linearVelocity.subLocal(vec23);
            body.m_angularVelocity -= this.m_invIA * f2;
            vec23.set(vec25).mulLocal(this.m_invMassB);
            body2.m_linearVelocity.addLocal(vec23);
            body2.m_angularVelocity += this.m_invIB * f3;
            this.pool.pushVec2(1);
        } else {
            this.m_impulse.setZero();
            this.m_motorImpulse = 0.0f;
        }
        this.pool.pushVec2(4);
    }

    public void solveVelocityConstraints(TimeStep timeStep) {
        float f;
        float f2;
        Vec2 vec2;
        float f3;
        float f4;
        float f5;
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        Vec2 vec22 = body.m_linearVelocity;
        float f6 = body.m_angularVelocity;
        Vec2 vec23 = body2.m_linearVelocity;
        float f7 = body2.m_angularVelocity;
        Vec2 vec24 = this.pool.popVec2();
        if (this.m_enableMotor && this.m_limitState != LimitState.EQUAL) {
            vec24.set(vec23).subLocal(vec22);
            f5 = Vec2.dot(this.m_axis, vec24) + this.m_a2 * f7 - this.m_a1 * f6;
            f4 = this.m_motorMass * (this.m_motorSpeed - f5);
            float f8 = this.m_motorImpulse;
            f3 = timeStep.dt * this.m_maxMotorForce;
            this.m_motorImpulse = MathUtils.clamp(this.m_motorImpulse + f4, -f3, f3);
            f4 = this.m_motorImpulse - f8;
            vec2 = this.pool.popVec2();
            vec2.set(this.m_axis).mulLocal(f4);
            f2 = f4 * this.m_a1;
            f = f4 * this.m_a2;
            vec24.set(vec2).mulLocal(this.m_invMassA);
            vec22.subLocal(vec24);
            f6 -= this.m_invIA * f2;
            vec24.set(vec2).mulLocal(this.m_invMassB);
            vec23.addLocal(vec24);
            f7 += this.m_invIB * f;
            this.pool.pushVec2(1);
        }
        vec24.set(vec23).subLocal(vec22);
        f5 = Vec2.dot(this.m_perp, vec24) + this.m_s2 * f7 - this.m_s1 * f6;
        if (this.m_enableLimit && this.m_limitState != LimitState.INACTIVE) {
            vec24.set(vec23).subLocal(vec22);
            f4 = Vec2.dot(this.m_axis, vec24) + this.m_a2 * f7 - this.m_a1 * f6;
            Vec2 vec25 = this.pool.popVec2();
            vec25.set(f5, f4);
            Vec2 vec26 = this.pool.popVec2();
            vec26.set(this.m_impulse);
            vec2 = this.pool.popVec2();
            this.m_K.solveToOut(vec25.negateLocal(), vec2);
            this.m_impulse.addLocal(vec2);
            if (this.m_limitState == LimitState.AT_LOWER) {
                this.m_impulse.y = MathUtils.max(this.m_impulse.y, 0.0f);
            } else if (this.m_limitState == LimitState.AT_UPPER) {
                this.m_impulse.y = MathUtils.min(this.m_impulse.y, 0.0f);
            }
            f2 = -f5 - (this.m_impulse.y - vec26.y) * this.m_K.col2.x;
            f = this.m_K.col1.x != 0.0f ? f2 / this.m_K.col1.x + vec26.x : vec26.x;
            this.m_impulse.x = f;
            vec2.set(this.m_impulse).subLocal(vec26);
            Vec2 vec27 = this.pool.popVec2();
            vec24.set(this.m_axis).mulLocal(vec2.y);
            vec27.set(this.m_perp).mulLocal(vec2.x).addLocal(vec24);
            float f9 = vec2.x * this.m_s1 + vec2.y * this.m_a1;
            float f10 = vec2.x * this.m_s2 + vec2.y * this.m_a2;
            vec24.set(vec27).mulLocal(this.m_invMassA);
            vec22.subLocal(vec24);
            f6 -= this.m_invIA * f9;
            vec24.set(vec27).mulLocal(this.m_invMassB);
            vec23.addLocal(vec24);
            f7 += this.m_invIB * f10;
            this.pool.pushVec2(4);
        } else {
            f4 = this.m_K.col1.x != 0.0f ? -f5 / this.m_K.col1.x : 0.0f;
            this.m_impulse.x += f4;
            Vec2 vec28 = this.pool.popVec2();
            vec28.set(this.m_perp).mulLocal(f4);
            f3 = f4 * this.m_s1;
            float f11 = f4 * this.m_s2;
            vec24.set(vec28).mulLocal(this.m_invMassA);
            vec22.subLocal(vec24);
            f6 -= this.m_invIA * f3;
            vec24.set(vec28).mulLocal(this.m_invMassB);
            vec23.addLocal(vec24);
            f7 += this.m_invIB * f11;
            this.pool.pushVec2(1);
        }
        this.pool.pushVec2(1);
        body.m_angularVelocity = f6;
        body2.m_angularVelocity = f7;
    }

    public boolean solvePositionConstraints(float f) {
        float f2;
        float f3;
        float f4;
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        Vec2 vec2 = body.m_sweep.c;
        float f5 = body.m_sweep.a;
        Vec2 vec22 = body2.m_sweep.c;
        float f6 = body2.m_sweep.a;
        float f7 = 0.0f;
        float f8 = 0.0f;
        boolean bl = false;
        float f9 = 0.0f;
        Mat22 mat22 = this.pool.popMat22();
        Mat22 mat222 = this.pool.popMat22();
        mat22.set(f5);
        mat222.set(f6);
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        Vec2 vec25 = this.pool.popVec2();
        Vec2 vec26 = this.pool.popVec2();
        vec23.set(this.m_localAnchor1).subLocal(this.m_localCenterA);
        vec24.set(this.m_localAnchor2).subLocal(this.m_localCenterB);
        Mat22.mulToOut(mat22, vec23, vec23);
        Mat22.mulToOut(mat222, vec24, vec24);
        vec26.set(vec22).addLocal(vec24).subLocal(vec2).subLocal(vec23);
        if (this.m_enableLimit) {
            Mat22.mulToOut(mat22, this.m_localXAxis1, this.m_axis);
            vec25.set(vec26).addLocal(vec23);
            this.m_a1 = Vec2.cross(vec25, this.m_axis);
            this.m_a2 = Vec2.cross(vec24, this.m_axis);
            float f10 = Vec2.dot(this.m_axis, vec26);
            if (MathUtils.abs(this.m_upperTranslation - this.m_lowerTranslation) < 2.0f * Settings.linearSlop) {
                f9 = MathUtils.clamp(f10, -Settings.maxLinearCorrection, Settings.maxLinearCorrection);
                f7 = MathUtils.abs(f10);
                bl = true;
            } else if (f10 <= this.m_lowerTranslation) {
                f9 = MathUtils.clamp(f10 - this.m_lowerTranslation + Settings.linearSlop, -Settings.maxLinearCorrection, 0.0f);
                f7 = this.m_lowerTranslation - f10;
                bl = true;
            } else if (f10 >= this.m_upperTranslation) {
                f9 = MathUtils.clamp(f10 - this.m_upperTranslation - Settings.linearSlop, 0.0f, Settings.maxLinearCorrection);
                f7 = f10 - this.m_upperTranslation;
                bl = true;
            }
        }
        Mat22.mulToOut(mat22, this.m_localYAxis1, this.m_perp);
        vec25.set(vec26).addLocal(vec23);
        this.m_s1 = Vec2.cross(vec25, this.m_perp);
        this.m_s2 = Vec2.cross(vec24, this.m_perp);
        Vec2 vec27 = this.pool.popVec2();
        float f11 = Vec2.dot(this.m_perp, vec26);
        f7 = MathUtils.max(f7, MathUtils.abs(f11));
        f8 = 0.0f;
        if (bl) {
            f4 = this.m_invMassA;
            f3 = this.m_invMassB;
            f2 = this.m_invIA;
            float f12 = this.m_invIB;
            float f13 = f4 + f3 + f2 * this.m_s1 * this.m_s1 + f12 * this.m_s2 * this.m_s2;
            float f14 = f2 * this.m_s1 * this.m_a1 + f12 * this.m_s2 * this.m_a2;
            float f15 = f4 + f3 + f2 * this.m_a1 * this.m_a1 + f12 * this.m_a2 * this.m_a2;
            this.m_K.col1.set(f13, f14);
            this.m_K.col2.set(f14, f15);
            Vec2 vec28 = this.pool.popVec2();
            vec28.x = f11;
            vec28.y = f9;
            this.m_K.solveToOut(vec28.negateLocal(), vec27);
            this.pool.pushVec2(1);
        } else {
            f4 = this.m_invMassA;
            f3 = this.m_invMassB;
            f2 = this.m_invIA;
            float f16 = this.m_invIB;
            float f17 = f4 + f3 + f2 * this.m_s1 * this.m_s1 + f16 * this.m_s2 * this.m_s2;
            float f18 = f17 != 0.0f ? -f11 / f17 : 0.0f;
            vec27.x = f18;
            vec27.y = 0.0f;
        }
        Vec2 vec29 = this.pool.popVec2();
        vec25.set(this.m_axis).mulLocal(vec27.y);
        vec29.set(this.m_perp).mulLocal(vec27.x).add(vec25);
        f3 = vec27.x * this.m_s1 + vec27.y * this.m_a1;
        f2 = vec27.x * this.m_s2 + vec27.y * this.m_a2;
        vec25.set(vec29).mulLocal(this.m_invMassA);
        vec2.subLocal(vec25);
        vec25.set(vec29).mulLocal(this.m_invMassB);
        vec22.addLocal(vec25);
        body.m_sweep.a = f5 -= this.m_invIA * f3;
        body2.m_sweep.a = f6 += this.m_invIB * f2;
        body.synchronizeTransform();
        body2.synchronizeTransform();
        this.pool.pushVec2(6);
        this.pool.pushMat22(2);
        return f7 <= Settings.linearSlop && f8 <= Settings.angularSlop;
    }
}

