/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.LimitState;
import org.jbox2d.dynamics.joints.PulleyJointDef;
import org.jbox2d.pooling.IWorldPool;

public class PulleyJoint
extends Joint {
    public static final float MIN_PULLEY_LENGTH = 2.0f;
    private final Vec2 m_groundAnchor1 = new Vec2();
    private final Vec2 m_groundAnchor2 = new Vec2();
    private final Vec2 m_localAnchor1 = new Vec2();
    private final Vec2 m_localAnchor2 = new Vec2();
    private final Vec2 m_u1 = new Vec2();
    private final Vec2 m_u2 = new Vec2();
    private float m_constant;
    private float m_ratio;
    private float m_maxLength1;
    private float m_maxLength2;
    private float m_pulleyMass;
    private float m_limitMass1;
    private float m_limitMass2;
    private float m_impulse;
    private float m_limitImpulse1;
    private float m_limitImpulse2;
    private LimitState m_state;
    private LimitState m_limitState1;
    private LimitState m_limitState2;

    public PulleyJoint(IWorldPool iWorldPool, PulleyJointDef pulleyJointDef) {
        super(iWorldPool, pulleyJointDef);
        this.m_groundAnchor1.set(pulleyJointDef.groundAnchorA);
        this.m_groundAnchor2.set(pulleyJointDef.groundAnchorB);
        this.m_localAnchor1.set(pulleyJointDef.localAnchorA);
        this.m_localAnchor2.set(pulleyJointDef.localAnchorB);
        assert (pulleyJointDef.ratio != 0.0f);
        this.m_ratio = pulleyJointDef.ratio;
        this.m_constant = pulleyJointDef.lengthA + this.m_ratio * pulleyJointDef.lengthB;
        this.m_maxLength1 = MathUtils.min(pulleyJointDef.maxLengthA, this.m_constant - this.m_ratio * 2.0f);
        this.m_maxLength2 = MathUtils.min(pulleyJointDef.maxLengthB, (this.m_constant - 2.0f) / this.m_ratio);
        this.m_impulse = 0.0f;
        this.m_limitImpulse1 = 0.0f;
        this.m_limitImpulse2 = 0.0f;
    }

    public void getAnchorA(Vec2 vec2) {
        this.m_bodyA.getWorldPointToOut(this.m_localAnchor1, vec2);
    }

    public void getAnchorB(Vec2 vec2) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchor2, vec2);
    }

    public void getReactionForce(float f, Vec2 vec2) {
        vec2.set(this.m_u2).mulLocal(this.m_impulse).mulLocal(f);
    }

    public float getReactionTorque(float f) {
        return 0.0f;
    }

    public Vec2 getGroundAnchorA() {
        return this.m_groundAnchor1;
    }

    public Vec2 getGroundAnchorB() {
        return this.m_groundAnchor2;
    }

    public float getLength1() {
        Vec2 vec2 = this.pool.popVec2();
        this.m_bodyA.getWorldPointToOut(this.m_localAnchor1, vec2);
        vec2.subLocal(this.m_groundAnchor1);
        float f = vec2.length();
        this.pool.pushVec2(1);
        return f;
    }

    public float getLength2() {
        Vec2 vec2 = this.pool.popVec2();
        this.m_bodyB.getWorldPointToOut(this.m_localAnchor2, vec2);
        vec2.subLocal(this.m_groundAnchor2);
        float f = vec2.length();
        this.pool.pushVec2(1);
        return f;
    }

    public float getRatio() {
        return this.m_ratio;
    }

    public void initVelocityConstraints(TimeStep timeStep) {
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        Vec2 vec2 = this.pool.popVec2();
        Vec2 vec22 = this.pool.popVec2();
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        Vec2 vec25 = this.pool.popVec2();
        Vec2 vec26 = this.pool.popVec2();
        vec2.set(this.m_localAnchor1).subLocal(body.getLocalCenter());
        vec22.set(this.m_localAnchor2).subLocal(body2.getLocalCenter());
        Mat22.mulToOut(body.getTransform().R, vec2, vec2);
        Mat22.mulToOut(body2.getTransform().R, vec22, vec22);
        vec23.set(body.m_sweep.c).addLocal(vec2);
        vec24.set(body2.m_sweep.c).addLocal(vec22);
        vec25.set(this.m_groundAnchor1);
        vec26.set(this.m_groundAnchor2);
        this.m_u1.set(vec23).subLocal(vec25);
        this.m_u2.set(vec24).subLocal(vec26);
        float f = this.m_u1.length();
        float f2 = this.m_u2.length();
        if (f > Settings.linearSlop) {
            this.m_u1.mulLocal(1.0f / f);
        } else {
            this.m_u1.setZero();
        }
        if (f2 > Settings.linearSlop) {
            this.m_u2.mulLocal(1.0f / f2);
        } else {
            this.m_u2.setZero();
        }
        float f3 = this.m_constant - f - this.m_ratio * f2;
        if (f3 > 0.0f) {
            this.m_state = LimitState.INACTIVE;
            this.m_impulse = 0.0f;
        } else {
            this.m_state = LimitState.AT_UPPER;
        }
        if (f < this.m_maxLength1) {
            this.m_limitState1 = LimitState.INACTIVE;
            this.m_limitImpulse1 = 0.0f;
        } else {
            this.m_limitState1 = LimitState.AT_UPPER;
        }
        if (f2 < this.m_maxLength2) {
            this.m_limitState2 = LimitState.INACTIVE;
            this.m_limitImpulse2 = 0.0f;
        } else {
            this.m_limitState2 = LimitState.AT_UPPER;
        }
        float f4 = Vec2.cross(vec2, this.m_u1);
        float f5 = Vec2.cross(vec22, this.m_u2);
        this.m_limitMass1 = body.m_invMass + body.m_invI * f4 * f4;
        this.m_limitMass2 = body2.m_invMass + body2.m_invI * f5 * f5;
        this.m_pulleyMass = this.m_limitMass1 + this.m_ratio * this.m_ratio * this.m_limitMass2;
        assert (this.m_limitMass1 > 1.1920929E-7f);
        assert (this.m_limitMass2 > 1.1920929E-7f);
        assert (this.m_pulleyMass > 1.1920929E-7f);
        this.m_limitMass1 = 1.0f / this.m_limitMass1;
        this.m_limitMass2 = 1.0f / this.m_limitMass2;
        this.m_pulleyMass = 1.0f / this.m_pulleyMass;
        if (timeStep.warmStarting) {
            this.m_impulse *= timeStep.dtRatio;
            this.m_limitImpulse1 *= timeStep.dtRatio;
            this.m_limitImpulse2 *= timeStep.dtRatio;
            Vec2 vec27 = this.pool.popVec2();
            Vec2 vec28 = this.pool.popVec2();
            Vec2 vec29 = this.pool.popVec2();
            vec27.set(this.m_u1).mulLocal(-(this.m_impulse + this.m_limitImpulse1));
            vec28.set(this.m_u2).mulLocal(-this.m_ratio * this.m_impulse - this.m_limitImpulse2);
            vec29.set(vec27).mulLocal(body.m_invMass);
            body.m_linearVelocity.addLocal(vec29);
            body.m_angularVelocity += body.m_invI * Vec2.cross(vec2, vec27);
            vec29.set(vec28).mulLocal(body2.m_invMass);
            body2.m_linearVelocity.addLocal(vec29);
            body2.m_angularVelocity += body2.m_invI * Vec2.cross(vec22, vec28);
            this.pool.pushVec2(3);
        } else {
            this.m_impulse = 0.0f;
            this.m_limitImpulse1 = 0.0f;
            this.m_limitImpulse2 = 0.0f;
        }
        this.pool.pushVec2(6);
    }

    public void solveVelocityConstraints(TimeStep timeStep) {
        Vec2 vec2;
        float f;
        float f2;
        Vec2 vec22;
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        vec23.set(this.m_localAnchor1).subLocal(body.getLocalCenter());
        vec24.set(this.m_localAnchor2).subLocal(body2.getLocalCenter());
        Mat22.mulToOut(body.getTransform().R, vec23, vec23);
        Mat22.mulToOut(body2.getTransform().R, vec24, vec24);
        if (this.m_state == LimitState.AT_UPPER) {
            vec22 = this.pool.popVec2();
            Vec2 vec25 = this.pool.popVec2();
            Vec2.crossToOut(body.m_angularVelocity, vec23, vec22);
            Vec2.crossToOut(body2.m_angularVelocity, vec24, vec25);
            vec22.addLocal(body.m_linearVelocity);
            vec25.addLocal(body2.m_linearVelocity);
            f2 = -Vec2.dot(this.m_u1, vec22) - this.m_ratio * Vec2.dot(this.m_u2, vec25);
            f = this.m_pulleyMass * -f2;
            float f3 = this.m_impulse;
            this.m_impulse = MathUtils.max(0.0f, this.m_impulse + f);
            f = this.m_impulse - f3;
            vec2 = this.pool.popVec2();
            Vec2 vec26 = this.pool.popVec2();
            Vec2 vec27 = this.pool.popVec2();
            vec2.set(this.m_u1).mulLocal(-f);
            vec26.set(this.m_u2).mulLocal(-this.m_ratio * f);
            vec27.set(vec2).mulLocal(body.m_invMass);
            body.m_linearVelocity.addLocal(vec27);
            body.m_angularVelocity += body.m_invI * Vec2.cross(vec23, vec2);
            vec27.set(vec26).mulLocal(body2.m_invMass);
            body2.m_linearVelocity.addLocal(vec27);
            body2.m_angularVelocity += body2.m_invI * Vec2.cross(vec24, vec26);
            this.pool.pushVec2(5);
        }
        if (this.m_limitState1 == LimitState.AT_UPPER) {
            vec22 = this.pool.popVec2();
            Vec2.crossToOut(body.m_angularVelocity, vec23, vec22);
            vec22.addLocal(body.m_linearVelocity);
            float f4 = -Vec2.dot(this.m_u1, vec22);
            f2 = -this.m_limitMass1 * f4;
            f = this.m_limitImpulse1;
            this.m_limitImpulse1 = MathUtils.max(0.0f, this.m_limitImpulse1 + f2);
            f2 = this.m_limitImpulse1 - f;
            Vec2 vec28 = this.pool.popVec2();
            vec2 = this.pool.popVec2();
            vec28.set(this.m_u1).mulLocal(-f2);
            vec2.set(vec28).mulLocal(body.m_invMass);
            body.m_linearVelocity.addLocal(vec2);
            body.m_angularVelocity += body.m_invI * Vec2.cross(vec23, vec28);
            this.pool.pushVec2(3);
        }
        if (this.m_limitState2 == LimitState.AT_UPPER) {
            vec22 = this.pool.popVec2();
            Vec2.crossToOut(body2.m_angularVelocity, vec24, vec22);
            vec22.addLocal(body2.m_linearVelocity);
            float f5 = -Vec2.dot(this.m_u2, vec22);
            f2 = -this.m_limitMass2 * f5;
            f = this.m_limitImpulse2;
            this.m_limitImpulse2 = MathUtils.max(0.0f, this.m_limitImpulse2 + f2);
            f2 = this.m_limitImpulse2 - f;
            Vec2 vec29 = this.pool.popVec2();
            vec2 = this.pool.popVec2();
            vec29.set(this.m_u2).mulLocal(-f2);
            vec2.set(vec29).mulLocal(body2.m_invMass);
            body2.m_linearVelocity.addLocal(vec2);
            body2.m_angularVelocity += body2.m_invI * Vec2.cross(vec24, vec29);
            this.pool.pushVec2(3);
        }
        this.pool.pushVec2(2);
    }

    public boolean solvePositionConstraints(float f) {
        float f2;
        Vec2 vec2;
        Vec2 vec22;
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        vec23.set(this.m_groundAnchor1);
        vec24.set(this.m_groundAnchor2);
        float f3 = 0.0f;
        if (this.m_state == LimitState.AT_UPPER) {
            vec22 = this.pool.popVec2();
            vec2 = this.pool.popVec2();
            Vec2 vec25 = this.pool.popVec2();
            Vec2 vec26 = this.pool.popVec2();
            vec22.set(this.m_localAnchor1).subLocal(body.getLocalCenter());
            vec2.set(this.m_localAnchor2).subLocal(body2.getLocalCenter());
            Mat22.mulToOut(body.getTransform().R, vec22, vec22);
            Mat22.mulToOut(body2.getTransform().R, vec2, vec2);
            vec25.set(body.m_sweep.c).addLocal(vec22);
            vec26.set(body2.m_sweep.c).addLocal(vec2);
            this.m_u1.set(vec25).subLocal(vec23);
            this.m_u2.set(vec26).subLocal(vec24);
            f2 = this.m_u1.length();
            float f4 = this.m_u2.length();
            if (f2 > Settings.linearSlop) {
                this.m_u1.mulLocal(1.0f / f2);
            } else {
                this.m_u1.setZero();
            }
            if (f4 > Settings.linearSlop) {
                this.m_u2.mulLocal(1.0f / f4);
            } else {
                this.m_u2.setZero();
            }
            float f5 = this.m_constant - f2 - this.m_ratio * f4;
            f3 = MathUtils.max(f3, -f5);
            f5 = MathUtils.clamp(f5 + Settings.linearSlop, -Settings.maxLinearCorrection, 0.0f);
            float f6 = -this.m_pulleyMass * f5;
            Vec2 vec27 = this.pool.popVec2();
            Vec2 vec28 = this.pool.popVec2();
            Vec2 vec29 = this.pool.popVec2();
            vec27.set(this.m_u1).mulLocal(-f6);
            vec28.set(this.m_u2).mulLocal(-this.m_ratio * f6);
            vec29.set(vec27).mulLocal(body.m_invMass);
            body.m_sweep.c.addLocal(vec29);
            body.m_sweep.a += body.m_invI * Vec2.cross(vec22, vec27);
            vec29.set(vec28).mulLocal(body2.m_invMass);
            body2.m_sweep.c.addLocal(vec29);
            body2.m_sweep.a += body2.m_invI * Vec2.cross(vec2, vec28);
            body.synchronizeTransform();
            body2.synchronizeTransform();
            this.pool.pushVec2(7);
        }
        if (this.m_limitState1 == LimitState.AT_UPPER) {
            vec22 = this.pool.popVec2();
            vec2 = this.pool.popVec2();
            vec22.set(this.m_localAnchor1).subLocal(body.getLocalCenter());
            Mat22.mulToOut(body.getTransform().R, vec22, vec22);
            vec2.set(body.m_sweep.c).addLocal(vec22);
            this.m_u1.set(vec2).subLocal(vec23);
            float f7 = this.m_u1.length();
            if (f7 > Settings.linearSlop) {
                this.m_u1.mulLocal(1.0f / f7);
            } else {
                this.m_u1.setZero();
            }
            float f8 = this.m_maxLength1 - f7;
            f3 = MathUtils.max(f3, -f8);
            f8 = MathUtils.clamp(f8 + Settings.linearSlop, -Settings.maxLinearCorrection, 0.0f);
            f2 = -this.m_limitMass1 * f8;
            Vec2 vec210 = this.pool.popVec2();
            Vec2 vec211 = this.pool.popVec2();
            vec210.set(this.m_u1).mulLocal(-f2);
            vec211.set(vec210).mulLocal(body.m_invMass);
            body.m_sweep.c.addLocal(vec211);
            body.m_sweep.a += body.m_invI * Vec2.cross(vec22, vec210);
            body.synchronizeTransform();
            this.pool.pushVec2(4);
        }
        if (this.m_limitState2 == LimitState.AT_UPPER) {
            vec22 = this.pool.popVec2();
            vec2 = this.pool.popVec2();
            vec22.set(this.m_localAnchor2).subLocal(body2.getLocalCenter());
            Mat22.mulToOut(body2.getTransform().R, vec22, vec22);
            vec2.set(body2.m_sweep.c).addLocal(vec22);
            this.m_u2.set(vec2).subLocal(vec24);
            float f9 = this.m_u2.length();
            if (f9 > Settings.linearSlop) {
                this.m_u2.mulLocal(1.0f / f9);
            } else {
                this.m_u2.setZero();
            }
            float f10 = this.m_maxLength2 - f9;
            f3 = MathUtils.max(f3, -f10);
            f10 = MathUtils.clamp(f10 + Settings.linearSlop, -Settings.maxLinearCorrection, 0.0f);
            f2 = -this.m_limitMass2 * f10;
            Vec2 vec212 = this.pool.popVec2();
            Vec2 vec213 = this.pool.popVec2();
            vec212.set(this.m_u2).mulLocal(-f2);
            vec213.set(vec212).mulLocal(body2.m_invMass);
            body2.m_sweep.c.addLocal(vec213);
            body2.m_sweep.a += body2.m_invI * Vec2.cross(vec22, vec212);
            body2.synchronizeTransform();
            this.pool.pushVec2(4);
        }
        this.pool.pushVec2(2);
        return f3 < Settings.linearSlop;
    }
}

