/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import java.io.Serializable;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.Mat33;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.Vec3;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.LimitState;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.pooling.IWorldPool;

public class RevoluteJoint
extends Joint {
    public final Vec2 m_localAnchor1 = new Vec2();
    public final Vec2 m_localAnchor2 = new Vec2();
    public final Vec3 m_impulse = new Vec3();
    public float m_motorImpulse;
    public final Mat33 m_mass = new Mat33();
    public float m_motorMass;
    public boolean m_enableMotor;
    public float m_maxMotorTorque;
    public float m_motorSpeed;
    public boolean m_enableLimit;
    public float m_referenceAngle;
    public float m_lowerAngle;
    public float m_upperAngle;
    public LimitState m_limitState;

    public RevoluteJoint(IWorldPool iWorldPool, RevoluteJointDef revoluteJointDef) {
        super(iWorldPool, revoluteJointDef);
        this.m_localAnchor1.set(revoluteJointDef.localAnchorA);
        this.m_localAnchor2.set(revoluteJointDef.localAnchorB);
        this.m_referenceAngle = revoluteJointDef.referenceAngle;
        this.m_motorImpulse = 0.0f;
        this.m_lowerAngle = revoluteJointDef.lowerAngle;
        this.m_upperAngle = revoluteJointDef.upperAngle;
        this.m_maxMotorTorque = revoluteJointDef.maxMotorTorque;
        this.m_motorSpeed = revoluteJointDef.motorSpeed;
        this.m_enableLimit = revoluteJointDef.enableLimit;
        this.m_enableMotor = revoluteJointDef.enableMotor;
    }

    public void initVelocityConstraints(TimeStep timeStep) {
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        if (this.m_enableMotor || this.m_enableLimit) assert (body.m_invI > 0.0f || body2.m_invI > 0.0f);
        Vec2 vec2 = this.pool.popVec2();
        Vec2 vec22 = this.pool.popVec2();
        vec2.set(this.m_localAnchor1).subLocal(body.getLocalCenter());
        vec22.set(this.m_localAnchor2).subLocal(body2.getLocalCenter());
        Mat22.mulToOut(body.getTransform().R, vec2, vec2);
        Mat22.mulToOut(body2.getTransform().R, vec22, vec22);
        float f = body.m_invMass;
        float f2 = body2.m_invMass;
        float f3 = body.m_invI;
        float f4 = body2.m_invI;
        this.m_mass.col1.x = f + f2 + vec2.y * vec2.y * f3 + vec22.y * vec22.y * f4;
        this.m_mass.col2.x = -vec2.y * vec2.x * f3 - vec22.y * vec22.x * f4;
        this.m_mass.col3.x = -vec2.y * f3 - vec22.y * f4;
        this.m_mass.col1.y = this.m_mass.col2.x;
        this.m_mass.col2.y = f + f2 + vec2.x * vec2.x * f3 + vec22.x * vec22.x * f4;
        this.m_mass.col3.y = vec2.x * f3 + vec22.x * f4;
        this.m_mass.col1.z = this.m_mass.col3.x;
        this.m_mass.col2.z = this.m_mass.col3.y;
        this.m_mass.col3.z = f3 + f4;
        this.m_motorMass = f3 + f4;
        if (this.m_motorMass > 0.0f) {
            this.m_motorMass = 1.0f / this.m_motorMass;
        }
        if (!this.m_enableMotor) {
            this.m_motorImpulse = 0.0f;
        }
        if (this.m_enableLimit) {
            float f5 = body2.m_sweep.a - body.m_sweep.a - this.m_referenceAngle;
            if (MathUtils.abs(this.m_upperAngle - this.m_lowerAngle) < 2.0f * Settings.angularSlop) {
                this.m_limitState = LimitState.EQUAL;
            } else if (f5 <= this.m_lowerAngle) {
                if (this.m_limitState != LimitState.AT_LOWER) {
                    this.m_impulse.z = 0.0f;
                }
                this.m_limitState = LimitState.AT_LOWER;
            } else if (f5 >= this.m_upperAngle) {
                if (this.m_limitState != LimitState.AT_UPPER) {
                    this.m_impulse.z = 0.0f;
                }
                this.m_limitState = LimitState.AT_UPPER;
            } else {
                this.m_limitState = LimitState.INACTIVE;
                this.m_impulse.z = 0.0f;
            }
        } else {
            this.m_limitState = LimitState.INACTIVE;
        }
        if (timeStep.warmStarting) {
            this.m_impulse.mulLocal(timeStep.dtRatio);
            this.m_motorImpulse *= timeStep.dtRatio;
            Vec2 vec23 = this.pool.popVec2();
            Vec2 vec24 = this.pool.popVec2();
            vec24.set(this.m_impulse.x, this.m_impulse.y);
            vec23.set(vec24).mulLocal(f);
            body.m_linearVelocity.subLocal(vec23);
            body.m_angularVelocity -= f3 * (Vec2.cross(vec2, vec24) + this.m_motorImpulse + this.m_impulse.z);
            vec23.set(vec24).mulLocal(f2);
            body2.m_linearVelocity.addLocal(vec23);
            body2.m_angularVelocity += f4 * (Vec2.cross(vec22, vec24) + this.m_motorImpulse + this.m_impulse.z);
            this.pool.pushVec2(2);
        } else {
            this.m_impulse.setZero();
            this.m_motorImpulse = 0.0f;
        }
        this.pool.pushVec2(2);
    }

    public void solveVelocityConstraints(TimeStep timeStep) {
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        Vec2 vec2 = body.m_linearVelocity;
        float f = body.m_angularVelocity;
        Vec2 vec22 = body2.m_linearVelocity;
        float f2 = body2.m_angularVelocity;
        float f3 = body.m_invMass;
        float f4 = body2.m_invMass;
        float f5 = body.m_invI;
        float f6 = body2.m_invI;
        if (this.m_enableMotor && this.m_limitState != LimitState.EQUAL) {
            float f7 = f2 - f - this.m_motorSpeed;
            float f8 = this.m_motorMass * -f7;
            float f9 = this.m_motorImpulse;
            float f10 = timeStep.dt * this.m_maxMotorTorque;
            this.m_motorImpulse = MathUtils.clamp(this.m_motorImpulse + f8, -f10, f10);
            f8 = this.m_motorImpulse - f9;
            f -= f5 * f8;
            f2 += f6 * f8;
        }
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        Vec2 vec25 = this.pool.popVec2();
        if (this.m_enableLimit && this.m_limitState != LimitState.INACTIVE) {
            float f11;
            vec24.set(this.m_localAnchor1).subLocal(body.getLocalCenter());
            vec25.set(this.m_localAnchor2).subLocal(body2.getLocalCenter());
            Mat22.mulToOut(body.getTransform().R, vec24, vec24);
            Mat22.mulToOut(body2.getTransform().R, vec25, vec25);
            Vec2 vec26 = this.pool.popVec2();
            Vec3 vec3 = this.pool.popVec3();
            Vec2.crossToOut(f, vec24, vec23);
            Vec2.crossToOut(f2, vec25, vec26);
            vec26.addLocal(vec22).subLocal(vec2).subLocal(vec23);
            float f12 = f2 - f;
            vec3.set(vec26.x, vec26.y, f12);
            Vec3 vec32 = this.pool.popVec3();
            this.m_mass.solve33ToOut(vec3.negateLocal(), vec32);
            if (this.m_limitState == LimitState.EQUAL) {
                this.m_impulse.addLocal(vec32);
            } else if (this.m_limitState == LimitState.AT_LOWER) {
                f11 = this.m_impulse.z + vec32.z;
                if (f11 < 0.0f) {
                    this.m_mass.solve22ToOut(vec26.negateLocal(), vec23);
                    vec32.x = vec23.x;
                    vec32.y = vec23.y;
                    vec32.z = -this.m_impulse.z;
                    this.m_impulse.x += vec23.x;
                    this.m_impulse.y += vec23.y;
                    this.m_impulse.z = 0.0f;
                }
            } else if (this.m_limitState == LimitState.AT_UPPER && (f11 = this.m_impulse.z + vec32.z) > 0.0f) {
                this.m_mass.solve22ToOut(vec26.negateLocal(), vec23);
                vec32.x = vec23.x;
                vec32.y = vec23.y;
                vec32.z = -this.m_impulse.z;
                this.m_impulse.x += vec23.x;
                this.m_impulse.y += vec23.y;
                this.m_impulse.z = 0.0f;
            }
            Vec2 vec27 = this.pool.popVec2();
            vec27.set(vec32.x, vec32.y);
            vec23.set(vec27).mulLocal(f3);
            vec2.subLocal(vec23);
            f -= f5 * (Vec2.cross(vec24, vec27) + vec32.z);
            vec23.set(vec27).mulLocal(f4);
            vec22.addLocal(vec23);
            f2 += f6 * (Vec2.cross(vec25, vec27) + vec32.z);
            this.pool.pushVec2(2);
            this.pool.pushVec3(2);
        } else {
            vec24.set(this.m_localAnchor1).subLocal(body.getLocalCenter());
            vec25.set(this.m_localAnchor2).subLocal(body2.getLocalCenter());
            Mat22.mulToOut(body.getTransform().R, vec24, vec24);
            Mat22.mulToOut(body2.getTransform().R, vec25, vec25);
            Vec2 vec28 = this.pool.popVec2();
            Vec2 vec29 = this.pool.popVec2();
            Vec2.crossToOut(f, vec24, vec23);
            Vec2.crossToOut(f2, vec25, vec28);
            vec28.addLocal(vec22).subLocal(vec2).subLocal(vec23);
            this.m_mass.solve22ToOut(vec28.negateLocal(), vec29);
            this.m_impulse.x += vec29.x;
            this.m_impulse.y += vec29.y;
            vec23.set(vec29).mulLocal(f3);
            vec2.subLocal(vec23);
            f -= f5 * Vec2.cross(vec24, vec29);
            vec23.set(vec29).mulLocal(f4);
            vec22.addLocal(vec23);
            f2 += f6 * Vec2.cross(vec25, vec29);
            this.pool.pushVec2(2);
        }
        body.m_angularVelocity = f;
        body2.m_angularVelocity = f2;
        this.pool.pushVec2(3);
    }

    public boolean solvePositionConstraints(float f) {
        Serializable serializable;
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.m_enableLimit && this.m_limitState != LimitState.INACTIVE) {
            float f4;
            float f5 = body2.m_sweep.a - body.m_sweep.a - this.m_referenceAngle;
            float f6 = 0.0f;
            if (this.m_limitState == LimitState.EQUAL) {
                f4 = MathUtils.clamp(f5 - this.m_lowerAngle, -Settings.maxAngularCorrection, Settings.maxAngularCorrection);
                f6 = -this.m_motorMass * f4;
                f2 = MathUtils.abs(f4);
            } else if (this.m_limitState == LimitState.AT_LOWER) {
                f4 = f5 - this.m_lowerAngle;
                f2 = -f4;
                f4 = MathUtils.clamp(f4 + Settings.angularSlop, -Settings.maxAngularCorrection, 0.0f);
                f6 = -this.m_motorMass * f4;
            } else if (this.m_limitState == LimitState.AT_UPPER) {
                f2 = f4 = f5 - this.m_upperAngle;
                f4 = MathUtils.clamp(f4 - Settings.angularSlop, 0.0f, Settings.maxAngularCorrection);
                f6 = -this.m_motorMass * f4;
            }
            body.m_sweep.a -= body.m_invI * f6;
            body2.m_sweep.a += body2.m_invI * f6;
            body.synchronizeTransform();
            body2.synchronizeTransform();
        }
        Vec2 vec2 = this.pool.popVec2();
        Vec2 vec22 = this.pool.popVec2();
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        vec22.set(this.m_localAnchor1).subLocal(body.getLocalCenter());
        vec23.set(this.m_localAnchor2).subLocal(body2.getLocalCenter());
        Mat22.mulToOut(body.getTransform().R, vec22, vec22);
        Mat22.mulToOut(body2.getTransform().R, vec23, vec23);
        vec24.set(body2.m_sweep.c).addLocal(vec23).subLocal(body.m_sweep.c).subLocal(vec22);
        f3 = vec24.length();
        float f7 = body.m_invMass;
        float f8 = body2.m_invMass;
        float f9 = body.m_invI;
        float f10 = body2.m_invI;
        float f11 = 10.0f * Settings.linearSlop;
        if (vec24.lengthSquared() > f11 * f11) {
            serializable = this.pool.popVec2();
            float f12 = f7 + f8;
            if (f12 > 0.0f) {
                f12 = 1.0f / f12;
            }
            vec2.set(vec24).negateLocal().mulLocal(f12);
            ((Vec2)serializable).set(vec2).mulLocal(0.5f * f7);
            body.m_sweep.c.subLocal((Vec2)serializable);
            ((Vec2)serializable).set(vec2).mulLocal(0.5f * f8);
            body2.m_sweep.c.addLocal((Vec2)serializable);
            vec24.set(body2.m_sweep.c).addLocal(vec23).subLocal(body.m_sweep.c).subLocal(vec22);
            this.pool.pushVec2(1);
        }
        serializable = this.pool.popMat22();
        ((Mat22)serializable).col1.x = f7 + f8;
        ((Mat22)serializable).col2.x = 0.0f;
        ((Mat22)serializable).col1.y = 0.0f;
        ((Mat22)serializable).col2.y = f7 + f8;
        Mat22 mat22 = this.pool.popMat22();
        mat22.col1.x = f9 * vec22.y * vec22.y;
        mat22.col2.x = -f9 * vec22.x * vec22.y;
        mat22.col1.y = -f9 * vec22.x * vec22.y;
        mat22.col2.y = f9 * vec22.x * vec22.x;
        Mat22 mat222 = this.pool.popMat22();
        mat222.col1.x = f10 * vec23.y * vec23.y;
        mat222.col2.x = -f10 * vec23.x * vec23.y;
        mat222.col1.y = -f10 * vec23.x * vec23.y;
        mat222.col2.y = f10 * vec23.x * vec23.x;
        ((Mat22)serializable).addLocal(mat22).addLocal(mat222);
        ((Mat22)serializable).solveToOut(vec24.negateLocal(), vec2);
        vec24.set(vec2).mulLocal(body.m_invMass);
        body.m_sweep.c.subLocal(vec24);
        body.m_sweep.a -= body.m_invI * Vec2.cross(vec22, vec2);
        vec24.set(vec2).mulLocal(body2.m_invMass);
        body2.m_sweep.c.addLocal(vec24);
        body2.m_sweep.a += body2.m_invI * Vec2.cross(vec23, vec2);
        body.synchronizeTransform();
        body2.synchronizeTransform();
        this.pool.pushMat22(3);
        this.pool.pushVec2(4);
        return f3 <= Settings.linearSlop && f2 <= Settings.angularSlop;
    }

    public void getAnchorA(Vec2 vec2) {
        this.m_bodyA.getWorldPointToOut(this.m_localAnchor1, vec2);
    }

    public void getAnchorB(Vec2 vec2) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchor2, vec2);
    }

    public void getReactionForce(float f, Vec2 vec2) {
        vec2.set(this.m_impulse.x, this.m_impulse.y).mulLocal(f);
    }

    public float getReactionTorque(float f) {
        return f * this.m_impulse.z;
    }

    public float getJointAngle() {
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        return body2.m_sweep.a - body.m_sweep.a - this.m_referenceAngle;
    }

    public float getJointSpeed() {
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        return body2.m_angularVelocity - body.m_angularVelocity;
    }

    public boolean isMotorEnabled() {
        return this.m_enableMotor;
    }

    public void enableMotor(boolean bl) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_enableMotor = bl;
    }

    public float getMotorTorque() {
        return this.m_motorImpulse;
    }

    public void setMotorSpeed(float f) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_motorSpeed = f;
    }

    public void setMaxMotorTorque(float f) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_maxMotorTorque = f;
    }

    public boolean isLimitEnabled() {
        return this.m_enableLimit;
    }

    public void enableLimit(boolean bl) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_enableLimit = bl;
    }

    public float getLowerLimit() {
        return this.m_lowerAngle;
    }

    public float getUpperLimit() {
        return this.m_upperAngle;
    }

    public void setLimits(float f, float f2) {
        assert (f <= f2);
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_lowerAngle = f;
        this.m_upperAngle = f2;
    }
}

