/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.pooling;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import org.jbox2d.pooling.IDynamicStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableStack<E, T extends E>
implements IDynamicStack<E> {
    private static final Logger log = LoggerFactory.getLogger(MutableStack.class);
    private T[] stack;
    private int index = 0;
    private int size;
    private final Class<T> sClass;
    private final Class<?>[] params;
    private final Object[] args;

    public MutableStack(Class<T> clazz, int n) {
        this(clazz, n, null, null);
    }

    public MutableStack(Class<T> clazz, int n, Class<?>[] classArray, Object[] objectArray) {
        this.size = n;
        this.sClass = clazz;
        this.params = classArray;
        this.args = objectArray;
        this.stack = (Object[])Array.newInstance(this.sClass, n);
        for (int i = 0; i < n; ++i) {
            try {
                if (this.params != null) {
                    this.stack[i] = this.sClass.getConstructor(this.params).newInstance(this.args);
                    continue;
                }
                this.stack[i] = this.sClass.newInstance();
                continue;
            }
            catch (InstantiationException instantiationException) {
                log.error("Error creating pooled object " + this.sClass.getSimpleName(), instantiationException);
                assert (false) : "Error creating pooled object " + this.sClass.getCanonicalName();
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                log.error("Error creating pooled object " + this.sClass.getSimpleName(), illegalAccessException);
                assert (false) : "Error creating pooled object " + this.sClass.getCanonicalName();
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.error("Error creating pooled object " + this.sClass.getSimpleName(), illegalArgumentException);
                assert (false) : "Error creating pooled object " + this.sClass.getCanonicalName();
                continue;
            }
            catch (SecurityException securityException) {
                log.error("Error creating pooled object " + this.sClass.getSimpleName(), securityException);
                assert (false) : "Error creating pooled object " + this.sClass.getCanonicalName();
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                log.error("Error creating pooled object " + this.sClass.getSimpleName(), invocationTargetException);
                assert (false) : "Error creating pooled object " + this.sClass.getCanonicalName();
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                log.error("Error creating pooled object " + this.sClass.getSimpleName(), noSuchMethodException);
                assert (false) : "Error creating pooled object " + this.sClass.getCanonicalName();
                continue;
            }
        }
        this.index = 0;
    }

    private void extendStack() {
        Object[] objectArray = (Object[])Array.newInstance(this.sClass, this.size * 2);
        System.arraycopy(this.stack, 0, objectArray, 0, this.size);
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                if (this.params != null) {
                    objectArray[i] = this.sClass.getConstructor(this.params).newInstance(this.args);
                    continue;
                }
                objectArray[i] = this.sClass.newInstance();
                continue;
            }
            catch (InstantiationException instantiationException) {
                log.error("Error creating pooled object " + this.sClass.getSimpleName(), instantiationException);
                assert (false) : "Error creating pooled object " + this.sClass.getCanonicalName();
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                log.error("Error creating pooled object " + this.sClass.getSimpleName(), illegalAccessException);
                assert (false) : "Error creating pooled object " + this.sClass.getCanonicalName();
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.error("Error creating pooled object " + this.sClass.getSimpleName(), illegalArgumentException);
                assert (false) : "Error creating pooled object " + this.sClass.getCanonicalName();
                continue;
            }
            catch (SecurityException securityException) {
                log.error("Error creating pooled object " + this.sClass.getSimpleName(), securityException);
                assert (false) : "Error creating pooled object " + this.sClass.getCanonicalName();
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                log.error("Error creating pooled object " + this.sClass.getSimpleName(), invocationTargetException);
                assert (false) : "Error creating pooled object " + this.sClass.getCanonicalName();
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                log.error("Error creating pooled object " + this.sClass.getSimpleName(), noSuchMethodException);
                assert (false) : "Error creating pooled object " + this.sClass.getCanonicalName();
                continue;
            }
        }
        this.stack = objectArray;
        this.size = objectArray.length;
    }

    @Override
    public final E pop() {
        if (this.index >= this.size) {
            this.extendStack();
        }
        return (E)this.stack[this.index++];
    }

    @Override
    public final void push(E e) {
        assert (this.index > 0);
        this.stack[--this.index] = e;
    }
}

