/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.pooling;

import java.lang.reflect.Array;
import org.jbox2d.pooling.IOrderedStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedStack<E>
implements IOrderedStack<E> {
    private static final Logger log = LoggerFactory.getLogger(OrderedStack.class);
    private final E[] pool;
    private int index;
    private final int size;
    private final E[] container;

    public OrderedStack(Class<E> clazz, int n, int n2) {
        this.size = n;
        this.pool = (Object[])Array.newInstance(clazz, n);
        for (int i = 0; i < n; ++i) {
            try {
                this.pool[i] = clazz.newInstance();
                continue;
            }
            catch (InstantiationException instantiationException) {
                log.error("Error creating pooled object " + clazz.getSimpleName(), instantiationException);
                assert (false) : "Error creating pooled object " + clazz.getCanonicalName();
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                log.error("Error creating pooled object " + clazz.getSimpleName(), illegalAccessException);
                assert (false) : "Error creating pooled object " + clazz.getCanonicalName();
                continue;
            }
        }
        this.index = 0;
        this.container = (Object[])Array.newInstance(clazz, n2);
    }

    @Override
    public final E pop() {
        assert (this.index < this.size) : "End of stack reached, there is probably a leak somewhere";
        return this.pool[this.index++];
    }

    @Override
    public final E[] pop(int n) {
        assert (this.index + n < this.size) : "End of stack reached, there is probably a leak somewhere";
        assert (n <= this.container.length) : "Container array is too small";
        System.arraycopy(this.pool, this.index, this.container, 0, n);
        this.index += n;
        return this.container;
    }

    @Override
    public final void push(int n) {
        this.index -= n;
        assert (this.index >= 0) : "Beginning of stack reached, push/pops are unmatched";
    }
}

