/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.framework;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.jbox2d.testbed.framework.SidePanel;
import org.jbox2d.testbed.framework.TestPanel;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.tests.TestList;

public class TestbedMain
extends JFrame {
    private TestPanel panel;
    private int currTestIndex;
    private SidePanel side;

    public TestbedMain() {
        super("JBox2D Testbed");
        this.setLayout(new BorderLayout());
        TestbedSettings testbedSettings = new TestbedSettings();
        this.panel = new TestPanel(testbedSettings);
        this.panel.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '[') {
                    TestbedMain.this.lastTest();
                } else if (keyEvent.getKeyChar() == ']') {
                    TestbedMain.this.nextTest();
                }
            }
        });
        this.add((Component)this.panel, "Center");
        this.side = new SidePanel(testbedSettings);
        this.side.setMain(this);
        this.add((Component)new JScrollPane(this.side), "East");
        this.pack();
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
        this.currTestIndex = 0;
        this.panel.changeTest(TestList.tests.get(0));
    }

    public void nextTest() {
        int n = this.currTestIndex + 1;
        this.side.tests.setSelectedIndex(n %= TestList.tests.size());
    }

    public void lastTest() {
        int n = this.currTestIndex - 1;
        if (n < 0) {
            n += TestList.tests.size();
        }
        this.side.tests.setSelectedIndex(n);
    }

    public void resetTest() {
        this.panel.resetTest();
    }

    public void testChanged(int n) {
        if (n == -1) {
            return;
        }
        this.currTestIndex = n;
        this.panel.changeTest(TestList.tests.get(n));
        this.panel.grabFocus();
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        new TestbedMain();
    }
}

