/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class ConfinedTest
extends TestbedTest {
    int e_columnCount = 0;
    int e_rowCount = 0;

    public String getTestName() {
        return "Confined";
    }

    public void initTest() {
        BodyDef bodyDef = new BodyDef();
        Object object = this.m_world.createBody(bodyDef);
        Object object2 = new PolygonShape();
        ((PolygonShape)object2).setAsEdge(new Vec2(-10.0f, 0.0f), new Vec2(10.0f, 0.0f));
        ((Body)object).createFixture((Shape)object2, 0.0f);
        ((PolygonShape)object2).setAsEdge(new Vec2(-10.0f, 0.0f), new Vec2(-10.0f, 20.0f));
        ((Body)object).createFixture((Shape)object2, 0.0f);
        ((PolygonShape)object2).setAsEdge(new Vec2(10.0f, 0.0f), new Vec2(10.0f, 20.0f));
        ((Body)object).createFixture((Shape)object2, 0.0f);
        ((PolygonShape)object2).setAsEdge(new Vec2(-10.0f, 20.0f), new Vec2(10.0f, 20.0f));
        ((Body)object).createFixture((Shape)object2, 0.0f);
        float f = 0.5f;
        object = new CircleShape();
        ((CircleShape)object).m_p.setZero();
        ((CircleShape)object).m_radius = f;
        object2 = new FixtureDef();
        ((FixtureDef)object2).shape = object;
        ((FixtureDef)object2).density = 1.0f;
        ((FixtureDef)object2).friction = 0.1f;
        for (int i = 0; i < this.e_columnCount; ++i) {
            for (int j = 0; j < this.e_rowCount; ++j) {
                BodyDef bodyDef2 = new BodyDef();
                bodyDef2.type = BodyType.DYNAMIC;
                bodyDef2.position.set(-10.0f + (2.1f * (float)i + 1.0f + 0.01f * (float)j) * f, (2.0f * (float)j + 1.0f) * f);
                Body body = this.m_world.createBody(bodyDef2);
                body.createFixture((FixtureDef)object2);
            }
        }
        this.m_world.setGravity(new Vec2(0.0f, 0.0f));
    }

    public void createCircle() {
        float f = 2.0f;
        CircleShape circleShape = new CircleShape();
        circleShape.m_p.setZero();
        circleShape.m_radius = f;
        FixtureDef fixtureDef = new FixtureDef();
        fixtureDef.shape = circleShape;
        fixtureDef.density = 1.0f;
        fixtureDef.friction = 0.0f;
        Vec2 vec2 = new Vec2((float)Math.random(), 3.0f + (float)Math.random());
        BodyDef bodyDef = new BodyDef();
        bodyDef.type = BodyType.DYNAMIC;
        bodyDef.position = vec2;
        Body body = this.m_world.createBody(bodyDef);
        body.createFixture(fixtureDef);
    }

    public void step(TestbedSettings testbedSettings) {
        super.step(testbedSettings);
        for (Body body = this.m_world.getBodyList(); body != null; body = body.getNext()) {
            if (body.getType() != BodyType.DYNAMIC) continue;
            Vec2 vec2 = body.getPosition();
            if (!(vec2.x <= -10.0f || 10.0f <= vec2.x || vec2.y <= 0.0f) && !(20.0f <= vec2.y)) continue;
            vec2.x = (float)((double)vec2.x + 0.0);
        }
        this.addTextLine("Press 'c' to create a circle");
    }

    public void keyPressed(char c, int n) {
        switch (c) {
            case 'c': {
                this.createCircle();
            }
        }
    }
}

