/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.World;
import org.jbox2d.testbed.framework.TestbedTest;

public class DominoTower
extends TestbedTest {
    private boolean firstTime = true;
    final float dwidth = 0.2f;
    final float dheight = 1.0f;
    float ddensity;
    final float dfriction = 0.1f;
    int baseCount = 25;

    public void makeDomino(float f, float f2, boolean bl, World world) {
        PolygonShape polygonShape = new PolygonShape();
        polygonShape.setAsBox(0.1f, 0.5f);
        FixtureDef fixtureDef = new FixtureDef();
        fixtureDef.shape = polygonShape;
        fixtureDef.density = this.ddensity;
        BodyDef bodyDef = new BodyDef();
        bodyDef.type = BodyType.DYNAMIC;
        fixtureDef.friction = 0.1f;
        fixtureDef.restitution = 0.65f;
        bodyDef.position = new Vec2(f, f2);
        bodyDef.angle = bl ? 1.5707964f : 0.0f;
        Body body = world.createBody(bodyDef);
        body.createFixture(fixtureDef);
    }

    public void initTest() {
        int n;
        if (this.firstTime) {
            this.setCamera(0.0f, 12.0f, 10.0f);
            this.firstTime = false;
        }
        PolygonShape polygonShape = new PolygonShape();
        polygonShape.setAsBox(50.0f, 10.0f);
        Object object = new BodyDef();
        ((BodyDef)object).position = new Vec2(0.0f, -10.0f);
        this.m_world.createBody((BodyDef)object).createFixture(polygonShape, 0.0f);
        this.ddensity = 10.0f;
        polygonShape = new PolygonShape();
        polygonShape.setAsBox(0.7f, 0.7f);
        object = new FixtureDef();
        ((FixtureDef)object).density = 35.0f;
        BodyDef bodyDef = new BodyDef();
        bodyDef.type = BodyType.DYNAMIC;
        ((FixtureDef)object).shape = polygonShape;
        ((FixtureDef)object).friction = 0.0f;
        ((FixtureDef)object).restitution = 0.85f;
        bodyDef.bullet = true;
        bodyDef.position = new Vec2(30.0f, 50.0f);
        Body body = this.m_world.createBody(bodyDef);
        body.createFixture((FixtureDef)object);
        body.setLinearVelocity(new Vec2(-25.0f, -25.0f));
        body.setAngularVelocity(6.7f);
        ((FixtureDef)object).density = 25.0f;
        bodyDef.position = new Vec2(-30.0f, 25.0f);
        body = this.m_world.createBody(bodyDef);
        body.createFixture((FixtureDef)object);
        body.setLinearVelocity(new Vec2(35.0f, -10.0f));
        body.setAngularVelocity(-8.3f);
        for (n = 0; n < this.baseCount; ++n) {
            float f = (float)n * 1.5f * 1.0f - 1.5f * (float)this.baseCount / 2.0f;
            this.makeDomino(f, 0.5f, false, this.m_world);
            this.makeDomino(f, 1.1f, true, this.m_world);
        }
        float f = (float)this.baseCount * 1.5f * 1.0f - 1.5f * (float)this.baseCount / 2.0f;
        for (n = 1; n < this.baseCount; ++n) {
            if (n > 3) {
                this.ddensity *= 0.8f;
            }
            float f2 = 0.5f + 1.386f * (float)n;
            for (int i = 0; i < this.baseCount - n; ++i) {
                f = (float)i * 1.5f * 1.0f - 1.5f * (float)(this.baseCount - n) / 2.0f;
                this.ddensity *= 2.5f;
                if (i == 0) {
                    this.makeDomino(f - 1.25f + 0.1f, f2 - 0.2f, false, this.m_world);
                }
                if (i == this.baseCount - n - 1) {
                    this.makeDomino(f + 1.25f - 0.1f, f2 - 0.2f, false, this.m_world);
                }
                this.ddensity /= 2.5f;
                this.makeDomino(f, f2, false, this.m_world);
                this.makeDomino(f, f2 + 0.6f, true, this.m_world);
                this.makeDomino(f, f2 - 0.6f, true, this.m_world);
            }
        }
    }

    public String getTestName() {
        return "Domino Tower";
    }
}

