/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.callbacks.DebugDraw;
import org.jbox2d.callbacks.QueryCallback;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.pooling.IWorldPool;

class PolyShapesCallback
implements QueryCallback {
    int e_maxCount = 30;
    CircleShape m_circle = new CircleShape();
    Transform m_transform = new Transform();
    DebugDraw debugDraw;
    int m_count = 0;
    IWorldPool p;

    public PolyShapesCallback(IWorldPool iWorldPool) {
        this.p = iWorldPool;
    }

    void DrawFixture(Fixture fixture) {
        Color3f color3f = new Color3f(0.95f, 0.95f, 0.6f);
        Transform transform = fixture.getBody().getTransform();
        switch (fixture.getType()) {
            case CIRCLE: {
                CircleShape circleShape = (CircleShape)fixture.getShape();
                Vec2 vec2 = Transform.mul(transform, circleShape.m_p);
                float f = circleShape.m_radius;
                this.debugDraw.drawCircle(vec2, f, color3f);
                break;
            }
            case POLYGON: {
                PolygonShape polygonShape = (PolygonShape)fixture.getShape();
                int n = polygonShape.m_vertexCount;
                assert (n <= Settings.maxPolygonVertices);
                Vec2[] vec2Array = new Vec2[Settings.maxPolygonVertices];
                for (int i = 0; i < n; ++i) {
                    vec2Array[i] = Transform.mul(transform, polygonShape.m_vertices[i]);
                }
                this.debugDraw.drawPolygon(vec2Array, n, color3f);
            }
        }
    }

    public boolean reportFixture(Fixture fixture) {
        if (this.m_count == this.e_maxCount) {
            return false;
        }
        Body body = fixture.getBody();
        Shape shape = fixture.getShape();
        boolean bl = this.p.getCollision().testOverlap(shape, this.m_circle, body.getTransform(), this.m_transform);
        if (bl) {
            this.DrawFixture(fixture);
            ++this.m_count;
        }
        return true;
    }
}

