/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.joints.PrismaticJoint;
import org.jbox2d.dynamics.joints.PrismaticJointDef;
import org.jbox2d.testbed.framework.TestPanel;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class PrismaticTest
extends TestbedTest {
    PrismaticJoint m_joint;

    public void initTest() {
        Body body = null;
        Object object = new BodyDef();
        body = this.m_world.createBody((BodyDef)object);
        Object object2 = new PolygonShape();
        ((PolygonShape)object2).setAsEdge(new Vec2(-40.0f, 0.0f), new Vec2(40.0f, 0.0f));
        body.createFixture((Shape)object2, 0.0f);
        object = new PolygonShape();
        ((PolygonShape)object).setAsBox(2.0f, 0.5f);
        object2 = new BodyDef();
        ((BodyDef)object2).type = BodyType.DYNAMIC;
        ((BodyDef)object2).position.set(-10.0f, 10.0f);
        ((BodyDef)object2).angle = 1.5707964f;
        ((BodyDef)object2).allowSleep = false;
        Body body2 = this.m_world.createBody((BodyDef)object2);
        body2.createFixture((Shape)object, 5.0f);
        PrismaticJointDef prismaticJointDef = new PrismaticJointDef();
        Vec2 vec2 = new Vec2(2.0f, 1.0f);
        vec2.normalize();
        prismaticJointDef.initialize(body, body2, new Vec2(0.0f, 0.0f), vec2);
        prismaticJointDef.motorSpeed = 10.0f;
        prismaticJointDef.maxMotorForce = 10000.0f;
        prismaticJointDef.enableMotor = true;
        prismaticJointDef.lowerTranslation = 0.0f;
        prismaticJointDef.upperTranslation = 20.0f;
        prismaticJointDef.enableLimit = true;
        this.m_joint = (PrismaticJoint)this.m_world.createJoint(prismaticJointDef);
    }

    public void step(TestbedSettings testbedSettings) {
        super.step(testbedSettings);
        this.addTextLine("Keys: (l) limits, (m) motors, (s) speed");
        float f = this.m_joint.getMotorForce();
        this.addTextLine("Motor Force = " + f);
    }

    public void keyPressed(char c, int n) {
        switch (c) {
            case 'l': {
                this.m_joint.enableLimit(!this.m_joint.isLimitEnabled());
                TestPanel.keys[108] = false;
                break;
            }
            case 'm': {
                this.m_joint.enableMotor(!this.m_joint.isMotorEnabled());
                TestPanel.keys[109] = false;
                break;
            }
            case 's': {
                this.m_joint.setMotorSpeed(-this.m_joint.getMotorSpeed());
                TestPanel.keys[115] = false;
            }
        }
    }

    public String getTestName() {
        return "Prismatic";
    }
}

