/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.callbacks.RayCastCallback;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.Fixture;

class RayCastMultipleCallback
implements RayCastCallback {
    public int e_maxCount = 5;
    Vec2[] m_points = new Vec2[this.e_maxCount];
    Vec2[] m_normals = new Vec2[this.e_maxCount];
    int m_count;

    RayCastMultipleCallback() {
    }

    public void init() {
        for (int i = 0; i < this.e_maxCount; ++i) {
            this.m_points[i] = new Vec2();
            this.m_normals[i] = new Vec2();
        }
        this.m_count = 0;
    }

    public float reportFixture(Fixture fixture, Vec2 vec2, Vec2 vec22, float f) {
        Body body = fixture.getBody();
        int n = 0;
        Object object = body.getUserData();
        if (object != null && (n = ((Integer)object).intValue()) == 0) {
            return -1.0f;
        }
        assert (this.m_count < this.e_maxCount);
        this.m_points[this.m_count].set(vec2);
        this.m_normals[this.m_count].set(vec22);
        ++this.m_count;
        if (this.m_count == this.e_maxCount) {
            return 0.0f;
        }
        return 1.0f;
    }
}

