/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.testbed.framework.TestPanel;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class RevoluteTest
extends TestbedTest {
    private RevoluteJoint m_joint;
    private boolean isLeft = false;

    public void initTest() {
        Body body = null;
        Object object = new BodyDef();
        body = this.m_world.createBody((BodyDef)object);
        Object object2 = new PolygonShape();
        ((PolygonShape)object2).setAsEdge(new Vec2(-40.0f, 0.0f), new Vec2(40.0f, 0.0f));
        body.createFixture((Shape)object2, 0.0f);
        object = new CircleShape();
        ((CircleShape)object).m_radius = 0.5f;
        object2 = new BodyDef();
        ((BodyDef)object2).type = BodyType.DYNAMIC;
        RevoluteJointDef revoluteJointDef = new RevoluteJointDef();
        ((BodyDef)object2).position.set(0.0f, 20.0f);
        Body body2 = this.m_world.createBody((BodyDef)object2);
        body2.createFixture((Shape)object, 5.0f);
        float f = 100.0f;
        body2.setAngularVelocity(f);
        body2.setLinearVelocity(new Vec2(-8.0f * f, 0.0f));
        revoluteJointDef.initialize(body, body2, new Vec2(0.0f, 12.0f));
        revoluteJointDef.motorSpeed = (float)(-Math.PI);
        revoluteJointDef.maxMotorTorque = 10000.0f;
        revoluteJointDef.enableMotor = false;
        revoluteJointDef.lowerAngle = -0.7853982f;
        revoluteJointDef.upperAngle = 1.5707964f;
        revoluteJointDef.enableLimit = true;
        revoluteJointDef.collideConnected = true;
        this.m_joint = (RevoluteJoint)this.m_world.createJoint(revoluteJointDef);
    }

    public void step(TestbedSettings testbedSettings) {
        super.step(testbedSettings);
        this.addTextLine("Limits " + (this.m_joint.isLimitEnabled() ? "on" : "off") + ", Motor " + (this.m_joint.isMotorEnabled() ? "on " : "off ") + (this.isLeft ? "left" : "right"));
        this.addTextLine("Keys: (l) limits, (m) motor, (a) left, (d) right");
    }

    public void keyPressed(char c, int n) {
        switch (c) {
            case 'l': {
                this.m_joint.enableLimit(!this.m_joint.isLimitEnabled());
                TestPanel.keys[108] = false;
                break;
            }
            case 'm': {
                this.m_joint.enableMotor(!this.m_joint.isMotorEnabled());
                TestPanel.keys[109] = false;
                break;
            }
            case 'a': {
                this.m_joint.setMotorSpeed((float)Math.PI);
                TestPanel.keys[97] = false;
                this.isLeft = true;
                break;
            }
            case 'd': {
                this.m_joint.setMotorSpeed((float)(-Math.PI));
                TestPanel.keys[100] = false;
                this.isLeft = false;
            }
        }
    }

    public String getTestName() {
        return "Revolute";
    }
}

