/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.joints.DistanceJointDef;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class TheoJansen
extends TestbedTest {
    Vec2 m_offset = new Vec2();
    Body m_chassis;
    Body m_wheel;
    RevoluteJoint m_motorJoint;
    boolean m_motorOn;
    float m_motorSpeed;

    public void initTest() {
        this.m_offset.set(0.0f, 8.0f);
        this.m_motorSpeed = 2.0f;
        this.m_motorOn = true;
        Vec2 vec2 = new Vec2(0.0f, 0.8f);
        BodyDef bodyDef = new BodyDef();
        Object object = this.m_world.createBody(bodyDef);
        Object object2 = new PolygonShape();
        ((PolygonShape)object2).setAsEdge(new Vec2(-50.0f, 0.0f), new Vec2(50.0f, 0.0f));
        ((Body)object).createFixture((Shape)object2, 0.0f);
        ((PolygonShape)object2).setAsEdge(new Vec2(-50.0f, 0.0f), new Vec2(-50.0f, 10.0f));
        ((Body)object).createFixture((Shape)object2, 0.0f);
        ((PolygonShape)object2).setAsEdge(new Vec2(50.0f, 0.0f), new Vec2(50.0f, 10.0f));
        ((Body)object).createFixture((Shape)object2, 0.0f);
        for (int i = 0; i < 40; ++i) {
            object = new CircleShape();
            ((CircleShape)object).m_radius = 0.25f;
            object2 = new BodyDef();
            ((BodyDef)object2).type = BodyType.DYNAMIC;
            ((BodyDef)object2).position.set(-40.0f + 2.0f * (float)i, 0.5f);
            Body body = this.m_world.createBody((BodyDef)object2);
            body.createFixture((Shape)object, 1.0f);
        }
        Object object3 = new PolygonShape();
        ((PolygonShape)object3).setAsBox(2.5f, 1.0f);
        object = new FixtureDef();
        ((FixtureDef)object).density = 1.0f;
        ((FixtureDef)object).shape = object3;
        ((FixtureDef)object).filter.groupIndex = -1;
        object2 = new BodyDef();
        ((BodyDef)object2).type = BodyType.DYNAMIC;
        ((BodyDef)object2).position.set(vec2).addLocal(this.m_offset);
        this.m_chassis = this.m_world.createBody((BodyDef)object2);
        this.m_chassis.createFixture((FixtureDef)object);
        object3 = new CircleShape();
        ((CircleShape)object3).m_radius = 1.6f;
        object = new FixtureDef();
        ((FixtureDef)object).density = 1.0f;
        ((FixtureDef)object).shape = object3;
        ((FixtureDef)object).filter.groupIndex = -1;
        object2 = new BodyDef();
        ((BodyDef)object2).type = BodyType.DYNAMIC;
        ((BodyDef)object2).position.set(vec2).addLocal(this.m_offset);
        this.m_wheel = this.m_world.createBody((BodyDef)object2);
        this.m_wheel.createFixture((FixtureDef)object);
        object3 = new RevoluteJointDef();
        ((RevoluteJointDef)object3).initialize(this.m_wheel, this.m_chassis, vec2.add(this.m_offset));
        ((RevoluteJointDef)object3).collideConnected = false;
        ((RevoluteJointDef)object3).motorSpeed = this.m_motorSpeed;
        ((RevoluteJointDef)object3).maxMotorTorque = 400.0f;
        ((RevoluteJointDef)object3).enableMotor = this.m_motorOn;
        this.m_motorJoint = (RevoluteJoint)this.m_world.createJoint((JointDef)object3);
        object3 = vec2.add(new Vec2(0.0f, -0.8f));
        this.createLeg(-1.0f, (Vec2)object3);
        this.createLeg(1.0f, (Vec2)object3);
        this.m_wheel.setTransform(this.m_wheel.getPosition(), 2.0943952f);
        this.createLeg(-1.0f, (Vec2)object3);
        this.createLeg(1.0f, (Vec2)object3);
        this.m_wheel.setTransform(this.m_wheel.getPosition(), -2.0943952f);
        this.createLeg(-1.0f, (Vec2)object3);
        this.createLeg(1.0f, (Vec2)object3);
    }

    void createLeg(float f, Vec2 vec2) {
        Object object;
        Vec2 vec22 = new Vec2(5.4f * f, -6.1f);
        Vec2 vec23 = new Vec2(7.2f * f, -1.2f);
        Vec2 vec24 = new Vec2(4.3f * f, -1.9f);
        Vec2 vec25 = new Vec2(3.1f * f, 0.8f);
        Vec2 vec26 = new Vec2(6.0f * f, 1.5f);
        Vec2 vec27 = new Vec2(2.5f * f, 3.7f);
        FixtureDef fixtureDef = new FixtureDef();
        FixtureDef fixtureDef2 = new FixtureDef();
        fixtureDef.filter.groupIndex = -1;
        fixtureDef2.filter.groupIndex = -1;
        fixtureDef.density = 1.0f;
        fixtureDef2.density = 1.0f;
        PolygonShape polygonShape = new PolygonShape();
        PolygonShape polygonShape2 = new PolygonShape();
        if (f > 0.0f) {
            object = new Vec2[]{vec22, vec23, vec24};
            polygonShape.set((Vec2[])object, 3);
            object[0] = new Vec2();
            object[1] = vec26.sub(vec25);
            object[2] = vec27.sub(vec25);
            polygonShape2.set((Vec2[])object, 3);
        } else {
            object = new Vec2[]{vec22, vec24, vec23};
            polygonShape.set((Vec2[])object, 3);
            object[0] = new Vec2();
            object[1] = vec27.sub(vec25);
            object[2] = vec26.sub(vec25);
            polygonShape2.set((Vec2[])object, 3);
        }
        fixtureDef.shape = polygonShape;
        fixtureDef2.shape = polygonShape2;
        object = new BodyDef();
        BodyDef bodyDef = new BodyDef();
        object.type = BodyType.DYNAMIC;
        bodyDef.type = BodyType.DYNAMIC;
        object.position = this.m_offset;
        bodyDef.position = vec25.add(this.m_offset);
        object.angularDamping = 10.0f;
        bodyDef.angularDamping = 10.0f;
        Body body = this.m_world.createBody((BodyDef)object);
        Body body2 = this.m_world.createBody(bodyDef);
        body.createFixture(fixtureDef);
        body2.createFixture(fixtureDef2);
        DistanceJointDef distanceJointDef = new DistanceJointDef();
        distanceJointDef.dampingRatio = 0.5f;
        distanceJointDef.frequencyHz = 10.0f;
        distanceJointDef.initialize(body, body2, vec23.add(this.m_offset), vec26.add(this.m_offset));
        this.m_world.createJoint(distanceJointDef);
        distanceJointDef.initialize(body, body2, vec24.add(this.m_offset), vec25.add(this.m_offset));
        this.m_world.createJoint(distanceJointDef);
        distanceJointDef.initialize(body, this.m_wheel, vec24.add(this.m_offset), vec2.add(this.m_offset));
        this.m_world.createJoint(distanceJointDef);
        distanceJointDef.initialize(body2, this.m_wheel, vec27.add(this.m_offset), vec2.add(this.m_offset));
        this.m_world.createJoint(distanceJointDef);
        RevoluteJointDef revoluteJointDef = new RevoluteJointDef();
        revoluteJointDef.initialize(body2, this.m_chassis, vec25.add(this.m_offset));
        this.m_world.createJoint(revoluteJointDef);
    }

    public void keyPressed(char c, int n) {
        switch (c) {
            case 'a': {
                this.m_motorJoint.setMotorSpeed(-this.m_motorSpeed);
                break;
            }
            case 's': {
                this.m_motorJoint.setMotorSpeed(0.0f);
                break;
            }
            case 'd': {
                this.m_motorJoint.setMotorSpeed(this.m_motorSpeed);
                break;
            }
            case 'm': {
                this.m_motorJoint.enableMotor(!this.m_motorJoint.isMotorEnabled());
            }
        }
    }

    public void step(TestbedSettings testbedSettings) {
        super.step(testbedSettings);
        this.addTextLine("Keys: left = a, brake = s, right = d, toggle motor = m");
    }

    public String getTestName() {
        return "TheoJansen Walker";
    }
}

