/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.utests;

import java.util.Random;
import junit.framework.TestCase;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;

public class MathTest
extends TestCase {
    private static final int MAX = Integer.MAX_VALUE;
    private static final int RAND_ITERS = 100;

    public void testFastMath() {
        float f;
        float f2;
        int n;
        Random random = new Random();
        for (n = 0; n < 100; ++n) {
            f2 = random.nextFloat() * 2.1474836E9f - 1.0737418E9f;
            MathTest.assertEquals((int)Math.floor(f2), MathUtils.floor(f2));
        }
        for (n = 0; n < 100; ++n) {
            f2 = random.nextFloat() * 2.1474836E9f - 1.0737418E9f;
            MathTest.assertEquals((int)Math.ceil(f2), MathUtils.ceil(f2));
        }
        for (n = 0; n < 100; ++n) {
            f2 = random.nextFloat() * 2.1474836E9f - 1.0737418E9f;
            f = random.nextFloat() * 2.1474836E9f - 1.0737418E9f;
            MathTest.assertEquals(Float.valueOf(Math.max(f2, f)), Float.valueOf(MathUtils.max(f2, f)));
        }
        for (n = 0; n < 100; ++n) {
            f2 = random.nextFloat() * 2.1474836E9f - 1.0737418E9f;
            f = random.nextFloat() * 2.1474836E9f - 1.0737418E9f;
            MathTest.assertEquals(Float.valueOf(Math.min(f2, f)), Float.valueOf(MathUtils.min(f2, f)));
        }
        for (n = 0; n < 100; ++n) {
            f2 = random.nextFloat() * 2.1474836E9f - 1.0737418E9f;
            MathTest.assertEquals(Math.round(f2), MathUtils.round(f2));
        }
        for (n = 0; n < 100; ++n) {
            f2 = random.nextFloat() * 2.1474836E9f - 1.0737418E9f;
            MathTest.assertEquals(Float.valueOf(Math.abs(f2)), Float.valueOf(MathUtils.abs(f2)));
        }
    }

    public void testVec2() {
        Vec2 vec2 = new Vec2();
        vec2.x = 0.0f;
        vec2.y = 1.0f;
        vec2.subLocal(new Vec2(10.0f, 10.0f));
        MathTest.assertEquals(Float.valueOf(-10.0f), Float.valueOf(vec2.x));
        MathTest.assertEquals(Float.valueOf(-9.0f), Float.valueOf(vec2.y));
        Vec2 vec22 = vec2.add(new Vec2(1.0f, 1.0f));
        MathTest.assertEquals(Float.valueOf(-9.0f), Float.valueOf(vec22.x));
        MathTest.assertEquals(Float.valueOf(-8.0f), Float.valueOf(vec22.y));
        MathTest.assertFalse(vec2.equals(vec22));
    }
}

