/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.util.sph;

import org.jbox2d.common.Vec2;
import org.jbox2d.util.sph.Parameter;
import org.jbox2d.util.sph.Particle;

public class SmoothParticle
extends Particle {
    public int ID;
    protected double pressure;
    protected double density;
    protected double h;
    protected double c;
    protected double ChangeDensity;
    protected Vec2 ChangeVelocity;
    protected int shapeID;
    protected int numNeighbors;
    protected double minDensity;
    protected double maxDensity;

    public SmoothParticle() {
        this.pressure = 0.0;
        this.density = 0.0;
        this.h = 0.0;
        this.c = 0.0;
        this.ChangeDensity = 0.0;
        this.ChangeVelocity = new Vec2(0.0f, 0.0f);
        this.ID = 0;
        this.shapeID = -1;
        this.minDensity = 999999.0;
        this.maxDensity = -999999.0;
        this.numNeighbors = 0;
    }

    public SmoothParticle(Vec2 vec2, Vec2 vec22, double d, double d2, double d3, double d4, double d5) {
        super(vec2, vec22, d);
        this.pressure = d3;
        this.density = d2;
        this.h = d4;
        this.c = d5;
        this.ChangeDensity = 0.0;
        this.ChangeVelocity = new Vec2(0.0f, 0.0f);
        this.shapeID = -1;
        this.ID = 0;
        this.minDensity = 999999.0;
        this.maxDensity = -999999.0;
        this.numNeighbors = 0;
    }

    public SmoothParticle(SmoothParticle smoothParticle) {
        this.pos = smoothParticle.pos.clone();
        this.vel = smoothParticle.vel.clone();
        this.mass = smoothParticle.mass;
        this.density = smoothParticle.getDensity();
        this.pressure = smoothParticle.getPressure();
        this.h = smoothParticle.getSmoothingLength();
        this.c = smoothParticle.getSpeedSound();
        this.minDensity = smoothParticle.getMinDensity();
        this.maxDensity = smoothParticle.getMaxDensity();
        this.ChangeVelocity = smoothParticle.getChangeVelocity();
        this.ChangeDensity = smoothParticle.getChangeDensity();
        this.deleted = smoothParticle.deleted;
        this.ID = smoothParticle.ID;
        this.shapeID = smoothParticle.shapeID;
        this.numNeighbors = smoothParticle.numNeighbors;
    }

    public void setPressure(double d) {
        this.pressure = d;
    }

    public void setDensity(double d) {
        this.density = d;
    }

    public void setSmoothingLength(double d) {
        this.h = d;
    }

    public void setSpeedSound(double d) {
        this.c = d;
    }

    public void setChangeVelocity(Vec2 vec2) {
        this.ChangeVelocity.set(vec2);
    }

    public void setChangeDensity(double d) {
        this.ChangeDensity = d;
    }

    public void setMinDensity(double d) {
        this.minDensity = d;
    }

    public void setMaxDensity(double d) {
        this.maxDensity = d;
    }

    public void setShapeID(int n) {
        this.shapeID = n;
    }

    public void setNumNeighbors(int n) {
        this.numNeighbors = n;
    }

    public double getPressure() {
        return this.pressure;
    }

    public double getSmoothingLength() {
        return this.h;
    }

    public double getDensity() {
        return this.density;
    }

    public double getSpeedSound() {
        return this.c;
    }

    public double getChangeDensity() {
        return this.ChangeDensity;
    }

    public Vec2 getChangeVelocity() {
        return this.ChangeVelocity;
    }

    public double getChangeVelocityX() {
        return this.ChangeVelocity.x;
    }

    public double getChangeVelocityY() {
        return this.ChangeVelocity.y;
    }

    public int getShapeID() {
        return this.shapeID;
    }

    public double getMinDensity() {
        return this.minDensity;
    }

    public double getMaxDensity() {
        return this.maxDensity;
    }

    public int getNumNeighbors() {
        return this.numNeighbors;
    }

    public void calcPressure(Parameter parameter) {
        this.pressure = parameter.c * parameter.c * this.density;
    }

    public void zeroSPHVars() {
        this.ChangeDensity = 0.0;
        this.ChangeVelocity.set(0.0f, 0.0f);
        this.numNeighbors = 0;
    }

    public void calcChangeDensity(SmoothParticle smoothParticle, Vec2 vec2) {
        this.ChangeDensity += smoothParticle.mass * ((double)vec2.x * this.gradientKernelX(smoothParticle) + (double)vec2.y * this.gradientKernelY(smoothParticle));
    }

    public void calcChangeVelocity(SmoothParticle smoothParticle, Vec2 vec2, Parameter parameter) {
        double d = this.pressureTerm(smoothParticle);
        double d2 = this.artificialViscosity(smoothParticle, parameter);
        double d3 = this.ChangeVelocity.x;
        double d4 = this.ChangeVelocity.y;
        this.ChangeVelocity.x = (float)(d3 + smoothParticle.mass * (d * this.gradientKernelX(smoothParticle) + (double)vec2.x * d2));
        this.ChangeVelocity.y = (float)(d4 + smoothParticle.mass * (d * this.gradientKernelY(smoothParticle) + (double)vec2.y * d2));
    }

    public void addForceX(Parameter parameter) {
        this.ChangeVelocity.x = (float)((double)this.ChangeVelocity.x + parameter.bodyFX);
    }

    public void addForceY(Parameter parameter) {
        this.ChangeVelocity.x = (float)((double)this.ChangeVelocity.y + parameter.bodyFY);
    }

    private double pressureTerm(SmoothParticle smoothParticle) {
        return -1.0 * (this.pressure / (this.density * this.density) + smoothParticle.getPressure() / (smoothParticle.getDensity() * smoothParticle.getDensity()));
    }

    protected double artificialViscosity(SmoothParticle smoothParticle, Parameter parameter) {
        double d = Math.sqrt((this.pos.x - smoothParticle.pos.x) * (this.pos.x - smoothParticle.pos.x) + (this.pos.y - smoothParticle.pos.y) * (this.pos.y - smoothParticle.pos.y));
        Vec2 vec2 = new Vec2(this.pos.x - smoothParticle.pos.x, this.pos.y - smoothParticle.pos.y);
        return parameter.nu * (this.density + smoothParticle.getDensity()) * ((double)vec2.x * this.gradientKernelX(smoothParticle) + (double)vec2.y * this.gradientKernelY(smoothParticle)) / (this.density * smoothParticle.getDensity() * (d * d + 0.01 * this.h * this.h));
    }

    protected double kernel(SmoothParticle smoothParticle) {
        double d = 0.0;
        double d2 = 10.0 / (Math.PI * 7 * this.h * this.h);
        double d3 = this.pos.x - smoothParticle.pos.x;
        double d4 = this.pos.y - smoothParticle.pos.y;
        d = Math.sqrt(d3 * d3 + d4 * d4);
        if (d < this.h) {
            return d2 * (1.0 - 1.5 * d * d / (this.h * this.h) + 0.75 * d * d * d / (this.h * this.h * this.h));
        }
        if (d < 2.0 * this.h) {
            return d2 * (2.0 - 3.0 * d / this.h + 1.5 * d * d / (this.h * this.h) - 0.25 * d * d * d / (this.h * this.h * this.h));
        }
        return 0.0;
    }

    protected double gradientKernelX(SmoothParticle smoothParticle) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 10.0 / (Math.PI * 7 * this.h * this.h);
        d2 = this.pos.x - smoothParticle.pos.x;
        d3 = this.pos.y - smoothParticle.pos.y;
        d = Math.sqrt(d2 * d2 + d3 * d3);
        if (d < this.h) {
            return d4 * (-3.0 / (this.h * this.h) + 9.0 * d / (4.0 * this.h * this.h * this.h)) * d2;
        }
        if (d < 2.0 * this.h) {
            return d4 * (-3.0 / (this.h * d) + 3.0 / (this.h * this.h) - 3.0 * d / (4.0 * this.h * this.h * this.h)) * d2;
        }
        return 0.0;
    }

    protected double gradientKernelY(SmoothParticle smoothParticle) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 10.0 / (Math.PI * 7 * this.h * this.h);
        d2 = this.pos.x - smoothParticle.pos.x;
        d3 = this.pos.y - smoothParticle.pos.y;
        d = Math.sqrt(d2 * d2 + d3 * d3);
        if (d < this.h) {
            return d4 * (-3.0 / (this.h * this.h) + 9.0 * d / (4.0 * this.h * this.h * this.h)) * d3;
        }
        if (d < 2.0 * this.h) {
            return d4 * (-3.0 / (this.h * d) + 3.0 / (this.h * this.h) - 3.0 * d / (4.0 * this.h * this.h * this.h)) * d3;
        }
        return 0.0;
    }

    public void setMinMaxDensity() {
        if (this.density > this.maxDensity) {
            this.maxDensity = this.density;
        } else if (this.density < this.minDensity) {
            this.minDensity = this.density;
        }
    }

    void updateNumNeighbors(SmoothParticle smoothParticle) {
        double d = Math.sqrt((this.pos.x - smoothParticle.pos.x) * (this.pos.x - smoothParticle.pos.x) + (this.pos.y - smoothParticle.pos.y) * (this.pos.y - smoothParticle.pos.y));
        if (d < 2.0 * this.h) {
            ++this.numNeighbors;
        }
    }
}

