/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.PhosphorusMonomer;
import org.jmol.util.Quaternion;

public class NucleicMonomer
extends PhosphorusMonomer {
    static final byte[] interestingNucleicAtomIDs = new byte[]{-14, 37, -80, 36, 32, 33, 34, 35, -39, -40, -41, -42, -48, -47, -43, -14, -45, -44, -73, -7, -89, 10, 9, -75, -77, -13, -9};
    private boolean hasRnaO2Prime;
    private static final byte[] ring6OffsetIndexes = new byte[]{3, 1, 4, 5, 6, 7};
    private static final byte[] ring5OffsetIndexes = new byte[]{3, 9, 10, 11, 7};
    private static final byte[] heavyAtomIndexes = new byte[]{3, 1, 4, 5, 6, 7, 11, 10, 9, 16, 14, 8, 12, 17, 13};
    Point3f baseCenter;

    public static Monomer validateAndAllocate(Chain chain, String string, int n, int n2, int n3, int[] nArray) {
        byte[] byArray = NucleicMonomer.scanForOffsets(n2, nArray, interestingNucleicAtomIDs);
        if (byArray == null) {
            return null;
        }
        if (!NucleicMonomer.checkOptional(byArray, (byte)19, n2, nArray[73])) {
            return null;
        }
        NucleicMonomer.checkOptional(byArray, (byte)20, n2, nArray[89]);
        NucleicMonomer.checkOptional(byArray, (byte)18, n2, nArray[90]);
        NucleicMonomer.checkOptional(byArray, (byte)23, n2, nArray[75]);
        NucleicMonomer.checkOptional(byArray, (byte)24, n2, nArray[77]);
        NucleicMonomer nucleicMonomer = new NucleicMonomer(chain, string, n, n2, n3, byArray);
        return nucleicMonomer;
    }

    NucleicMonomer(Chain chain, String string, int n, int n2, int n3, byte[] byArray) {
        super(chain, string, n, n2, n3, byArray);
        if (byArray[15] == -1 && (byArray[0] = byArray[18]) == -1) {
            byArray[0] = byArray[19];
            this.leadAtomIndex = n2 + (byArray[0] & 0xFF);
        }
        this.hasRnaO2Prime = byArray[2] != -1;
        this.isPyrimidine = byArray[8] != -1;
        this.isPurine = byArray[9] != -1 && byArray[10] != -1 && byArray[11] != -1;
    }

    public boolean isDna() {
        return !this.hasRnaO2Prime;
    }

    public boolean isRna() {
        return this.hasRnaO2Prime;
    }

    public boolean isPurine() {
        return this.isPurine;
    }

    public boolean isPyrimidine() {
        return this.isPyrimidine;
    }

    public boolean isGuanine() {
        return this.offsets[17] != -1;
    }

    public byte getProteinStructureType() {
        return this.hasRnaO2Prime ? (byte)5 : 4;
    }

    Atom getC4P() {
        return this.getAtomFromOffsetIndex(26);
    }

    Atom getN1() {
        return this.getAtomFromOffsetIndex(4);
    }

    Atom getN3() {
        return this.getAtomFromOffsetIndex(6);
    }

    Atom getN2() {
        return this.getAtomFromOffsetIndex(17);
    }

    Atom getN4() {
        return this.getAtomFromOffsetIndex(14);
    }

    Atom getN6() {
        return this.getAtomFromOffsetIndex(16);
    }

    Atom getO2() {
        return this.getAtomFromOffsetIndex(8);
    }

    Atom getO4() {
        return this.getAtomFromOffsetIndex(12);
    }

    Atom getO6() {
        return this.getAtomFromOffsetIndex(13);
    }

    Atom getTerminatorAtom() {
        return this.getAtomFromOffsetIndex(this.offsets[20] != -1 ? 20 : 21);
    }

    boolean isConnectedAfter(Monomer monomer) {
        if (monomer == null) {
            return true;
        }
        Atom atom = this.getAtomFromOffsetIndex(15);
        if (atom == null) {
            return false;
        }
        if (!(monomer instanceof NucleicMonomer)) {
            return false;
        }
        NucleicMonomer nucleicMonomer = (NucleicMonomer)monomer;
        if (nucleicMonomer.getAtomFromOffsetIndex(21).isBonded(atom)) {
            return true;
        }
        return super.isConnectedAfter(monomer);
    }

    Atom getN0() {
        return this.getAtomFromOffsetIndex(this.isPurine ? 11 : 4);
    }

    public Object getHelixData(int n, char c, int n2) {
        return this.getHelixData2(n, c, n2);
    }

    Point3f getQuaternionFrameCenter(char c) {
        switch (c) {
            case 'a': 
            case 'b': 
            case 'p': 
            case 'x': {
                return this.getP();
            }
            case 'c': {
                if (this.baseCenter == null) {
                    int n = 0;
                    this.baseCenter = new Point3f();
                    for (int i = 0; i < heavyAtomIndexes.length; ++i) {
                        Atom atom = this.getAtomFromOffsetIndex(heavyAtomIndexes[i]);
                        if (atom == null) continue;
                        this.baseCenter.add(atom);
                        ++n;
                    }
                    this.baseCenter.scale(1.0f / (float)n);
                }
                return this.baseCenter;
            }
        }
        return this.getN0();
    }

    public Quaternion getQuaternion(char c) {
        Tuple3f tuple3f;
        Tuple3f tuple3f2;
        Atom atom;
        Atom atom2 = null;
        Atom atom3 = null;
        boolean bl = false;
        boolean bl2 = false;
        switch (c) {
            case 'a': {
                atom = this.getP();
                if (this.monomerIndex == 0 || atom == null) {
                    return null;
                }
                bl = true;
                atom2 = ((NucleicMonomer)this.bioPolymer.monomers[this.monomerIndex - 1]).getC4P();
                atom3 = this.getC4P();
                break;
            }
            case 'x': {
                atom = this.getP();
                if (this.monomerIndex == this.bioPolymer.monomerCount - 1 || atom == null) {
                    return null;
                }
                atom2 = ((NucleicMonomer)this.bioPolymer.monomers[this.monomerIndex + 1]).getP();
                atom3 = this.getC4P();
                break;
            }
            case 'b': {
                return super.getQuaternion(c);
            }
            case 'c': 
            case 'n': {
                atom = this.getN0();
                if (atom == null) {
                    return null;
                }
                bl = true;
                bl2 = true;
                atom2 = this.getAtomFromOffsetIndex(5);
                atom3 = this.getAtomFromOffsetIndex(25);
                break;
            }
            case 'p': {
                atom = this.getP();
                if (atom == null) {
                    return null;
                }
                tuple3f2 = this.getAtomFromOffsetIndex(23);
                tuple3f = this.getAtomFromOffsetIndex(24);
                Bond[] bondArray = atom.getBonds();
                if (bondArray == null) {
                    return null;
                }
                Group group = atom.getGroup();
                for (int i = 0; i < bondArray.length; ++i) {
                    Atom atom4 = bondArray[i].getOtherAtom(atom);
                    if (tuple3f2 != null && atom4.index == ((Atom)tuple3f2).index || tuple3f != null && atom4.index == ((Atom)tuple3f).index) continue;
                    if (atom4.getGroup() == group) {
                        atom3 = atom4;
                        continue;
                    }
                    atom2 = atom4;
                }
                break;
            }
            case 'q': {
                return null;
            }
            default: {
                atom = this.getN0();
                if (atom == null) {
                    return null;
                }
                if (this.isPurine) {
                    atom2 = this.getAtomFromOffsetIndex(5);
                    atom3 = this.getAtomFromOffsetIndex(9);
                    break;
                }
                atom2 = this.getAtomFromOffsetIndex(6);
                atom3 = this.getAtomFromOffsetIndex(1);
            }
        }
        if (atom2 == null || atom3 == null) {
            return null;
        }
        tuple3f2 = new Vector3f(atom2);
        tuple3f2.sub(atom);
        tuple3f = new Vector3f(atom3);
        tuple3f.sub(atom);
        if (bl2) {
            tuple3f.scale(-1.0f);
        }
        return Quaternion.getQuaternionFrame((Vector3f)tuple3f2, (Vector3f)tuple3f, null, bl);
    }
}

